SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[HospitalContact]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[HospitalContact](
	[HospitalId] [int] NOT NULL,
	[ContactId] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_HospitalContact] PRIMARY KEY CLUSTERED 
(
	[HospitalId] ASC,
	[ContactId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalContact', N'COLUMN',N'HospitalId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to a hospital.
' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalContact', @level2type=N'COLUMN',@level2name=N'HospitalId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalContact', N'COLUMN',N'ContactId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to a single electronic contact number or address for this hospital' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalContact', @level2type=N'COLUMN',@level2name=N'ContactId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalContact', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Links a hospital to multiple electronic contact numbers or addresses, such as the phone number and fax number.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalContact'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalContact_Hospital]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalContact]'))
ALTER TABLE [hips].[HospitalContact]  WITH CHECK ADD  CONSTRAINT [FK_HospitalContact_Hospital] FOREIGN KEY([HospitalId])
REFERENCES [hips].[Hospital] ([HospitalId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalContact_Hospital]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalContact]'))
ALTER TABLE [hips].[HospitalContact] CHECK CONSTRAINT [FK_HospitalContact_Hospital]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalContact_HospitalContact]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalContact]'))
ALTER TABLE [hips].[HospitalContact]  WITH CHECK ADD  CONSTRAINT [FK_HospitalContact_HospitalContact] FOREIGN KEY([ContactId])
REFERENCES [hips].[Contact] ([ContactId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalContact_HospitalContact]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalContact]'))
ALTER TABLE [hips].[HospitalContact] CHECK CONSTRAINT [FK_HospitalContact_HospitalContact]
GO

