SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[HospitalHealthProviderIndividual]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[HospitalHealthProviderIndividual](
	[HospitalId] [int] NOT NULL,
	[HealthProviderIndividualId] [int] NOT NULL,
	[CisProviderIdentifier] [varchar](30) NULL,
	[PasProviderIdentifier] [varchar](30) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_HospitalProvider_1] PRIMARY KEY CLUSTERED 
(
	[HospitalId] ASC,
	[HealthProviderIndividualId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalHealthProviderIndividual', N'COLUMN',N'HospitalId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Hospital in which an individual provider works' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalHealthProviderIndividual', @level2type=N'COLUMN',@level2name=N'HospitalId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalHealthProviderIndividual', N'COLUMN',N'HealthProviderIndividualId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to an individual healthcare provider who works in the hospital' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalHealthProviderIndividual', @level2type=N'COLUMN',@level2name=N'HealthProviderIndividualId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalHealthProviderIndividual', N'COLUMN',N'CisProviderIdentifier'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifier of this provider allocated by the Clinical Information System (CIS) used at the hospital facility (e.g. Oacis User ID)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalHealthProviderIndividual', @level2type=N'COLUMN',@level2name=N'CisProviderIdentifier'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalHealthProviderIndividual', N'COLUMN',N'PasProviderIdentifier'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifier of this provider allocated by the Patient Administration System (PAS) at the hospital facility (e.g. Homer Doctor Code)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalHealthProviderIndividual', @level2type=N'COLUMN',@level2name=N'PasProviderIdentifier'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalHealthProviderIndividual', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies an individual health provider working at a particular hospital. This is a many-to-many join table and uses a composite primary key.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalHealthProviderIndividual'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalHealthProviderIndividual_HealthProviderIndividual]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalHealthProviderIndividual]'))
ALTER TABLE [hips].[HospitalHealthProviderIndividual]  WITH CHECK ADD  CONSTRAINT [FK_HospitalHealthProviderIndividual_HealthProviderIndividual] FOREIGN KEY([HealthProviderIndividualId])
REFERENCES [hips].[HealthProviderIndividual] ([HealthProviderIndividualId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalHealthProviderIndividual_HealthProviderIndividual]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalHealthProviderIndividual]'))
ALTER TABLE [hips].[HospitalHealthProviderIndividual] CHECK CONSTRAINT [FK_HospitalHealthProviderIndividual_HealthProviderIndividual]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalHealthProviderIndividual_Hospital]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalHealthProviderIndividual]'))
ALTER TABLE [hips].[HospitalHealthProviderIndividual]  WITH CHECK ADD  CONSTRAINT [FK_HospitalHealthProviderIndividual_Hospital] FOREIGN KEY([HospitalId])
REFERENCES [hips].[Hospital] ([HospitalId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalHealthProviderIndividual_Hospital]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalHealthProviderIndividual]'))
ALTER TABLE [hips].[HospitalHealthProviderIndividual] CHECK CONSTRAINT [FK_HospitalHealthProviderIndividual_Hospital]
GO

