SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[HospitalPatient]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[HospitalPatient](
	[PatientId] [int] IDENTITY(1,1) NOT NULL,
	[PatientMasterId] [int] NOT NULL,
	[HospitalId] [int] NOT NULL,
	[Mrn] [varchar](20) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_Patient_1] PRIMARY KEY CLUSTERED 
(
	[PatientId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalPatient', N'COLUMN',N'PatientId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Patient record at a single hospital facility' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalPatient', @level2type=N'COLUMN',@level2name=N'PatientId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalPatient', N'COLUMN',N'PatientMasterId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to the enterprise patient master record.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalPatient', @level2type=N'COLUMN',@level2name=N'PatientMasterId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalPatient', N'COLUMN',N'HospitalId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to the hospital facility.
' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalPatient', @level2type=N'COLUMN',@level2name=N'HospitalId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalPatient', N'COLUMN',N'Mrn'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifier for the patient, allocated by the PAS at this hospital.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalPatient', @level2type=N'COLUMN',@level2name=N'Mrn'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Patient_Hospital]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalPatient]'))
ALTER TABLE [hips].[HospitalPatient]  WITH CHECK ADD  CONSTRAINT [FK_Patient_Hospital] FOREIGN KEY([HospitalId])
REFERENCES [hips].[Hospital] ([HospitalId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Patient_Hospital]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalPatient]'))
ALTER TABLE [hips].[HospitalPatient] CHECK CONSTRAINT [FK_Patient_Hospital]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Patient_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalPatient]'))
ALTER TABLE [hips].[HospitalPatient]  WITH CHECK ADD  CONSTRAINT [FK_Patient_PatientMaster] FOREIGN KEY([PatientMasterId])
REFERENCES [hips].[PatientMaster] ([PatientMasterId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_Patient_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalPatient]'))
ALTER TABLE [hips].[HospitalPatient] CHECK CONSTRAINT [FK_Patient_PatientMaster]
GO

