SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[HospitalPatientHistory]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[HospitalPatientHistory](
	[HospitalPatientHistoryId] [int] IDENTITY(1,1) NOT NULL,
	[HospitalPatientId] [int] NOT NULL,
	[FromPatientMasterId] [int] NOT NULL,
	[ToPatientMasterId] [int] NOT NULL,
	[HospitalId] [int] NOT NULL,
	[FromMrn] [varchar](20) NOT NULL,
	[ToMrn] [varchar](20) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_HospitalPatientHistory_1] PRIMARY KEY CLUSTERED 
(
	[HospitalPatientHistoryId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalPatientHistory', N'COLUMN',N'HospitalPatientHistoryId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'History of changes to HospitalPatient record made during merges or moves' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalPatientHistory', @level2type=N'COLUMN',@level2name=N'HospitalPatientHistoryId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalPatientHistory', N'COLUMN',N'HospitalPatientHistoryId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifier of the HospitalPatient record in question' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalPatientHistory', @level2type=N'COLUMN',@level2name=N'HospitalPatientId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalPatientHistory', N'COLUMN',N'FromPatientMasterId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Previously linked enterprise patient master record.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalPatientHistory', @level2type=N'COLUMN',@level2name=N'FromPatientMasterId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalPatientHistory', N'COLUMN',N'ToPatientMasterId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Newly linked enterprise patient master record.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalPatientHistory', @level2type=N'COLUMN',@level2name=N'ToPatientMasterId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalPatientHistory', N'COLUMN',N'HospitalId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to the hospital facility.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalPatientHistory', @level2type=N'COLUMN',@level2name=N'HospitalId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalPatientHistory', N'COLUMN',N'FromMrn'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Previous identifier for the patient, allocated by the PAS at this hospital.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalPatientHistory', @level2type=N'COLUMN',@level2name=N'FromMrn'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HospitalPatientHistory', N'COLUMN',N'ToMrn'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'New identifier for the patient, allocated by the PAS at this hospital.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HospitalPatientHistory', @level2type=N'COLUMN',@level2name=N'ToMrn'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalPatientHistory_HospitalPatient]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalPatientHistory]'))
ALTER TABLE [hips].[HospitalPatientHistory]  WITH CHECK ADD  CONSTRAINT [FK_HospitalPatientHistory_HospitalPatient] FOREIGN KEY([HospitalPatientId])
REFERENCES [hips].[HospitalPatient] ([PatientId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalPatientHistory_HospitalPatient]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalPatientHistory]'))
ALTER TABLE [hips].[HospitalPatientHistory] CHECK CONSTRAINT [FK_HospitalPatientHistory_HospitalPatient]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalPatientHistory_Hospital]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalPatientHistory]'))
ALTER TABLE [hips].[HospitalPatientHistory]  WITH CHECK ADD  CONSTRAINT [FK_HospitalPatientHistory_Hospital] FOREIGN KEY([HospitalId])
REFERENCES [hips].[Hospital] ([HospitalId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalPatientHistory_Hospital]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalPatientHistory]'))
ALTER TABLE [hips].[HospitalPatientHistory] CHECK CONSTRAINT [FK_HospitalPatientHistory_Hospital]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalPatientHistory_FromPatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalPatientHistory]'))
ALTER TABLE [hips].[HospitalPatientHistory]  WITH CHECK ADD  CONSTRAINT [FK_HospitalPatientHistory_FromPatientMaster] FOREIGN KEY([FromPatientMasterId])
REFERENCES [hips].[PatientMaster] ([PatientMasterId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalPatientHistory_FromPatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalPatientHistory]'))
ALTER TABLE [hips].[HospitalPatientHistory] CHECK CONSTRAINT [FK_HospitalPatientHistory_FromPatientMaster]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalPatientHistory_ToPatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalPatientHistory]'))
ALTER TABLE [hips].[HospitalPatientHistory]  WITH CHECK ADD  CONSTRAINT [FK_HospitalPatientHistory_ToPatientMaster] FOREIGN KEY([ToPatientMasterId])
REFERENCES [hips].[PatientMaster] ([PatientMasterId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HospitalPatientHistory_ToPatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[HospitalPatientHistory]'))
ALTER TABLE [hips].[HospitalPatientHistory] CHECK CONSTRAINT [FK_HospitalPatientHistory_ToPatientMaster]
GO

