SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[HpiiLookupAudit]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[HpiiLookupAudit](
	[HpiiLookupAuditId] [int] IDENTITY(1,1) NOT NULL,
	[HpiiNumber] [varchar](50) NULL,
	[HpiiStatusId] [int] NULL,
	[RegistrationId] [varchar](20) NULL,
	[FamilyName] [varchar](40) NOT NULL,
	[GivenNames] [varchar](500) NULL,
	[DateOfBirth] [datetime] NULL,
	[SexId] [int] NULL,
	[AustralianStateId] [int] NULL,
	[Postcode] [varchar](4) NULL,
	[CountryId] [int] NULL,
	[BatchItemId] [int] NULL,
	[BatchId] [int] NULL,
	[Message] [varchar](200) NULL,
	[OperatorHpiI] [varchar](16) NULL,
	[HpiO] [varchar](16) NOT NULL,
	[Operator] [varchar](100) NOT NULL,
	[IdentifierType] [varchar](40) NULL,
	[IdentifierValue]  [varchar](128) NULL,
	[HiWebServiceName] [varchar](40) NOT NULL,
	[HiWebServiceVersion] [varchar](10) NOT NULL,
	[ServiceMessageRequestID] [varchar](50),
	[ServiceMessageResponseID] [varchar](50),
	[Request] [xml] NULL,
	[Response] [xml] NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_HpiiLookupAudit] PRIMARY KEY CLUSTERED 
(
	[HpiiLookupAuditId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'HpiiNumber'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'HPII Number of the provider used in the Search for an HPII' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'HpiiNumber'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'HpiiStatusId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'HPII Status of the returned HPII' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'HpiiStatusId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'RegistrationId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Registration Number of the provider used in the Search for an HPII' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'RegistrationId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'FamilyName'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Family Name of the provider used in the Search for an HPII' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'FamilyName'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'GivenNames'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Given Name of the provider used in the Search for an HPII' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'GivenNames'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'DateOfBirth'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date of birth of the provider used in the Search for an HPII' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'DateOfBirth'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'SexId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Gender Identifier used in the Search for an HPII' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'SexId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'AustralianStateId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Australian State Identifier used in the Search for an HPII' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'AustralianStateId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'Postcode'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Postcode used in the Search for an HPII' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'Postcode'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'CountryId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Country identifier used in the Search for an HPII' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'CountryId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'BatchItemId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Singular identifier of a request within a batch ' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'BatchItemId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'BatchId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Batch Identifier for the grouped batch request' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'BatchId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'Message'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Error or Warning Messages returned from the Hi Service ' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'Message'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'OperatorHpiI'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'HPII of the individual making the request' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'OperatorHpiI'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'HpiO'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'HPIO of the organisation making the request' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'HpiO'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'Operator'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Authorised operator that performed the request' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'Operator'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'IdentifierType'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Local Identifier Type of associated local record identifiers' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'IdentifierType'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'IdentifierValue'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Local Identifier Value of associated local record identifiers' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'IdentifierValue'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'HiWebServiceName'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Name of the HI Web Service called ' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'HiWebServiceName'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'HiWebServiceVersion'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Version of the HI Web Service called ' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'HiWebServiceVersion'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'ServiceMessageRequestID'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Service Message Request ID for the Hi Service' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'ServiceMessageRequestID'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'ServiceMessageResponseID'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Service Message Response ID for the Hi Service' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'ServiceMessageResponseID'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'Request'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Request XML for the Hi Service' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'Request'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'Response'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Response XML from the Hi Service' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'Response'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date that this patient record was inserted into the table' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User account that inserted the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and time that this record was last modified (or as inserted)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The account of the user that last modified (or inserted) this record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'UserModified'
GO


IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HpiiLookupAudit_Sex]') AND parent_object_id = OBJECT_ID(N'[hips].[HpiiLookupAudit]'))
ALTER TABLE [hips].[HpiiLookupAudit]  WITH CHECK ADD  CONSTRAINT [FK_HpiiLookupAudit_Sex] FOREIGN KEY([SexId])
REFERENCES [hips].[Sex] ([SexId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HpiiLookupAudit_Sex]') AND parent_object_id = OBJECT_ID(N'[hips].[HpiiLookupAudit]'))
ALTER TABLE [hips].[HpiiLookupAudit] CHECK CONSTRAINT [FK_HpiiLookupAudit_Sex]
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HpiiLookupAudit_Country]') AND parent_object_id = OBJECT_ID(N'[hips].[HpiiLookupAudit]'))
ALTER TABLE [hips].[HpiiLookupAudit]  WITH CHECK ADD  CONSTRAINT [FK_HpiiLookupAudit_Country] FOREIGN KEY([CountryId])
REFERENCES [hips].[Country] ([CountryId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HpiiLookupAudit_Country]') AND parent_object_id = OBJECT_ID(N'[hips].[HpiiLookupAudit]'))
ALTER TABLE [hips].[HpiiLookupAudit] CHECK CONSTRAINT [FK_HpiiLookupAudit_Country]
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HpiiLookupAudit_State]') AND parent_object_id = OBJECT_ID(N'[hips].[HpiiLookupAudit]'))
ALTER TABLE [hips].[HpiiLookupAudit]  WITH CHECK ADD  CONSTRAINT [FK_HpiiLookupAudit_State] FOREIGN KEY([AustralianStateId])
REFERENCES [hips].[State] ([StateId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HpiiLookupAudit_State]') AND parent_object_id = OBJECT_ID(N'[hips].[HpiiLookupAudit]'))
ALTER TABLE [hips].[HpiiLookupAudit] CHECK CONSTRAINT [FK_HpiiLookupAudit_State]
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HpiiLookupAudit_Status]') AND parent_object_id = OBJECT_ID(N'[hips].[HpiiLookupAudit]'))
ALTER TABLE [hips].[HpiiLookupAudit]  WITH CHECK ADD  CONSTRAINT [FK_HpiiLookupAudit_Status] FOREIGN KEY([HpiiStatusId])
REFERENCES [hips].[HpiiStatus] ([HpiiStatusId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HpiiLookupAudit_Status]') AND parent_object_id = OBJECT_ID(N'[hips].[HpiiLookupAudit]'))
ALTER TABLE [hips].[HpiiLookupAudit] CHECK CONSTRAINT [FK_HpiiLookupAudit_Status]
GO

