SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[IhiLookupAlert]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[IhiLookupAlert](
	[IhiLookupAlertId] [int] IDENTITY(1,1) NOT NULL,
	[PatientMasterId] [int] NOT NULL,
	[Message] [varchar](512) NOT NULL,
	[Request] [xml] NULL,
	[Response] [xml] NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
 CONSTRAINT [PK_IhiLookupAlert] PRIMARY KEY CLUSTERED 
(
	[IhiLookupAlertId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_IhiLookupAlert_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[IhiLookupAlert]'))
ALTER TABLE [hips].[IhiLookupAlert]  WITH CHECK ADD  CONSTRAINT [FK_IhiLookupAlert_PatientMaster] FOREIGN KEY([PatientMasterId])
REFERENCES [hips].[PatientMaster] ([PatientMasterId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_IhiLookupAlert_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[IhiLookupAlert]'))
ALTER TABLE [hips].[IhiLookupAlert] CHECK CONSTRAINT [FK_IhiLookupAlert_PatientMaster]
GO

