SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[IhiLookupAudit]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[IhiLookupAudit](
	[IhiLookupAuditId] [int] IDENTITY(1,1) NOT NULL,
	[PatientMasterId] [int] NOT NULL,
	[SequenceNumber] [int] NOT NULL,
	[IhiNumber] [varchar](50) NULL,
	[IhiStatus] [int] NOT NULL,
	[IhiRecordStatus] [int] NOT NULL,
	[FamilyName] [varchar](80) NOT NULL,
	[GivenName] [varchar](80) NOT NULL,
	[SexId] [int] NOT NULL,
	[DateOfBirth] [datetime] NOT NULL,
	[MedicareNumber] [varchar](12) NULL,
	[DvaNumber] [varchar](18) NULL,
	[Message] [varchar](200) NULL,
	[HpiI] [varchar](16) NULL,
	[HpiO] [varchar](16) NOT NULL,
	[Operator] [varchar](100) NOT NULL,
	[Request] [xml] NULL,
	[Response] [xml] NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_IhiLookupAudit] PRIMARY KEY CLUSTERED 
(
	[IhiLookupAuditId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'IhiLookupAudit', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date that this patient record was inserted into the table' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'IhiLookupAudit', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'IhiLookupAudit', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User account that inserted the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'IhiLookupAudit', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'IhiLookupAudit', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and time that this record was last modified (or as inserted)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'IhiLookupAudit', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'IhiLookupAudit', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The account of the user that last modified (or inserted) this record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'IhiLookupAudit', @level2type=N'COLUMN',@level2name=N'UserModified'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_IhiLookupAudit_IhiRecordStatus]') AND parent_object_id = OBJECT_ID(N'[hips].[IhiLookupAudit]'))
ALTER TABLE [hips].[IhiLookupAudit]  WITH CHECK ADD  CONSTRAINT [FK_IhiLookupAudit_IhiRecordStatus] FOREIGN KEY([IhiRecordStatus])
REFERENCES [hips].[IhiRecordStatus] ([IhiRecordStatusId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_IhiLookupAudit_IhiRecordStatus]') AND parent_object_id = OBJECT_ID(N'[hips].[IhiLookupAudit]'))
ALTER TABLE [hips].[IhiLookupAudit] CHECK CONSTRAINT [FK_IhiLookupAudit_IhiRecordStatus]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_IhiLookupAudit_IhiStatus]') AND parent_object_id = OBJECT_ID(N'[hips].[IhiLookupAudit]'))
ALTER TABLE [hips].[IhiLookupAudit]  WITH CHECK ADD  CONSTRAINT [FK_IhiLookupAudit_IhiStatus] FOREIGN KEY([IhiStatus])
REFERENCES [hips].[IhiStatus] ([IhiStatusId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_IhiLookupAudit_IhiStatus]') AND parent_object_id = OBJECT_ID(N'[hips].[IhiLookupAudit]'))
ALTER TABLE [hips].[IhiLookupAudit] CHECK CONSTRAINT [FK_IhiLookupAudit_IhiStatus]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_IhiLookupAudit_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[IhiLookupAudit]'))
ALTER TABLE [hips].[IhiLookupAudit]  WITH CHECK ADD  CONSTRAINT [FK_IhiLookupAudit_PatientMaster] FOREIGN KEY([PatientMasterId])
REFERENCES [hips].[PatientMaster] ([PatientMasterId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_IhiLookupAudit_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[IhiLookupAudit]'))
ALTER TABLE [hips].[IhiLookupAudit] CHECK CONSTRAINT [FK_IhiLookupAudit_PatientMaster]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_IhiLookupAudit_Sex]') AND parent_object_id = OBJECT_ID(N'[hips].[IhiLookupAudit]'))
ALTER TABLE [hips].[IhiLookupAudit]  WITH CHECK ADD  CONSTRAINT [FK_IhiLookupAudit_Sex] FOREIGN KEY([SexId])
REFERENCES [hips].[Sex] ([SexId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_IhiLookupAudit_Sex]') AND parent_object_id = OBJECT_ID(N'[hips].[IhiLookupAudit]'))
ALTER TABLE [hips].[IhiLookupAudit] CHECK CONSTRAINT [FK_IhiLookupAudit_Sex]
GO

