SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[MonitorTabMessage]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[MonitorTabMessage](
	[MonitorTabId] [int] NOT NULL,
	[LogMessageId] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_MonitorTabMessage] PRIMARY KEY CLUSTERED 
(
	[MonitorTabId] ASC
	,[LogMessageId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'MonitorTabMessage', N'COLUMN',N'MonitorTabId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to the monitor tab.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'MonitorTabMessage', @level2type=N'COLUMN',@level2name=N'MonitorTabId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'MonitorTabMessage', N'COLUMN',N'LogMessageId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to the log message.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'MonitorTabMessage', @level2type=N'COLUMN',@level2name=N'LogMessageId'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_MonitorTabMessage_LogMessage]') AND parent_object_id = OBJECT_ID(N'[hips].[MonitorTabMessage]'))
ALTER TABLE [hips].[MonitorTabMessage]  WITH CHECK ADD  CONSTRAINT [FK_MonitorTabMessage_LogMessage] FOREIGN KEY([LogMessageId])
REFERENCES [hips].[LogMessage] ([LogMessageId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_MonitorTabMessage_LogMessage]') AND parent_object_id = OBJECT_ID(N'[hips].[MonitorTabMessage]'))
ALTER TABLE [hips].[MonitorTabMessage] CHECK CONSTRAINT [FK_MonitorTabMessage_LogMessage]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_MonitorTabMessage_MonitorTab]') AND parent_object_id = OBJECT_ID(N'[hips].[MonitorTabMessage]'))
ALTER TABLE [hips].[MonitorTabMessage]  WITH CHECK ADD  CONSTRAINT [FK_MonitorTabMessage_MonitorTab] FOREIGN KEY([MonitorTabId])
REFERENCES [hips].[MonitorTab] ([MonitorTabId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_MonitorTabMessage_MonitorTab]') AND parent_object_id = OBJECT_ID(N'[hips].[MonitorTabMessage]'))
ALTER TABLE [hips].[MonitorTabMessage] CHECK CONSTRAINT [FK_MonitorTabMessage_MonitorTab]
GO

