SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[PatientMaster]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[PatientMaster](
	[PatientMasterId] [int] IDENTITY(1,1) NOT NULL,
	[CurrentSexId] [int] NOT NULL,
	[DateOfBirth] [datetime] NOT NULL,
	[DateOfDeath] [datetime] NULL,
	[DeathIndicatorId] [int] NULL,
	[MedicareNumber] [varchar](12) NULL,
	[MedicareIrn] [varchar](3) NULL,
	[IsMedicareNumberValid] [bit] NULL,
	[DvaNumber] [varchar](18) NULL,
	[StatePatientId] [varchar](64) NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_PatientMaster] PRIMARY KEY CLUSTERED 
(
	[PatientMasterId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMaster', N'COLUMN',N'PatientMasterId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Enterprise master patient record (from linked hospital facility records)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMaster', @level2type=N'COLUMN',@level2name=N'PatientMasterId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMaster', N'COLUMN',N'CurrentSexId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Sex supplied by the PAS' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMaster', @level2type=N'COLUMN',@level2name=N'CurrentSexId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMaster', N'COLUMN',N'DateOfBirth'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date of Birth supplied by the PAS' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMaster', @level2type=N'COLUMN',@level2name=N'DateOfBirth'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMaster', N'COLUMN',N'DateOfDeath'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date of Death (if applicable) supplied by the PAS' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMaster', @level2type=N'COLUMN',@level2name=N'DateOfDeath'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMaster', N'COLUMN',N'DeathIndicatorId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Death indicator as linked to Date of Death' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMaster', @level2type=N'COLUMN',@level2name=N'DeathIndicatorId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMaster', N'COLUMN',N'MedicareNumber'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Medicare Card Number (10 digits) supplied by the PAS' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMaster', @level2type=N'COLUMN',@level2name=N'MedicareNumber'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMaster', N'COLUMN',N'MedicareIrn'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Medicare Card Individual Reference Number (1 digit) supplied by the PAS' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMaster', @level2type=N'COLUMN',@level2name=N'MedicareIrn'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMaster', N'COLUMN',N'IsMedicareNumberValid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Whether the Medicare Card Number passed checksum validation' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMaster', @level2type=N'COLUMN',@level2name=N'IsMedicareNumberValid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMaster', N'COLUMN',N'DvaNumber'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Department of Veterans'' Affairs File Number supplied by the PAS' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMaster', @level2type=N'COLUMN',@level2name=N'DvaNumber'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMaster', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date that this patient record was inserted into the table' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMaster', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMaster', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User account that inserted the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMaster', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMaster', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and time that this record was last modified (or as inserted)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMaster', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMaster', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The account of the user that last modified (or inserted) this record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMaster', @level2type=N'COLUMN',@level2name=N'UserModified'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMaster_Sex]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMaster]'))
ALTER TABLE [hips].[PatientMaster]  WITH CHECK ADD  CONSTRAINT [FK_PatientMaster_Sex] FOREIGN KEY([CurrentSexId])
REFERENCES [hips].[Sex] ([SexId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMaster_Sex]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMaster]'))
ALTER TABLE [hips].[PatientMaster] CHECK CONSTRAINT [FK_PatientMaster_Sex]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMaster_DeathIndicator]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMaster]'))
ALTER TABLE [hips].[PatientMaster]  WITH CHECK ADD  CONSTRAINT [FK_PatientMaster_DeathIndicator] FOREIGN KEY([DeathIndicatorId])
REFERENCES [hips].[DeathIndicator] ([DeathIndicatorId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMaster_DeathIndicator]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMaster]'))
ALTER TABLE [hips].[PatientMaster] CHECK CONSTRAINT [FK_PatientMaster_DeathIndicator]
GO

