SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[PatientMasterAddress]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[PatientMasterAddress](
	[PatientMasterId] [int] NOT NULL,
	[AddressId] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_PatientMasterAddress_1] PRIMARY KEY CLUSTERED 
(
	[PatientMasterId] ASC,
	[AddressId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterAddress', N'COLUMN',N'PatientMasterId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to the patient master record
' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterAddress', @level2type=N'COLUMN',@level2name=N'PatientMasterId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterAddress', N'COLUMN',N'AddressId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to the address record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterAddress', @level2type=N'COLUMN',@level2name=N'AddressId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterAddress', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Links a patient master to multiple addresses.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterAddress'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterAddress_Address]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterAddress]'))
ALTER TABLE [hips].[PatientMasterAddress]  WITH CHECK ADD  CONSTRAINT [FK_PatientMasterAddress_Address] FOREIGN KEY([AddressId])
REFERENCES [hips].[Address] ([AddressId])
ON DELETE CASCADE
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterAddress_Address]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterAddress]'))
ALTER TABLE [hips].[PatientMasterAddress] CHECK CONSTRAINT [FK_PatientMasterAddress_Address]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterAddress_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterAddress]'))
ALTER TABLE [hips].[PatientMasterAddress]  WITH CHECK ADD  CONSTRAINT [FK_PatientMasterAddress_PatientMaster] FOREIGN KEY([PatientMasterId])
REFERENCES [hips].[PatientMaster] ([PatientMasterId])
ON DELETE CASCADE
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterAddress_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterAddress]'))
ALTER TABLE [hips].[PatientMasterAddress] CHECK CONSTRAINT [FK_PatientMasterAddress_PatientMaster]
GO

