SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[PatientMasterContact]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[PatientMasterContact](
	[PatientMasterId] [int] NOT NULL,
	[ContactId] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_PatientMasterContact] PRIMARY KEY CLUSTERED 
(
	[PatientMasterId] ASC,
	[ContactId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterContact', N'COLUMN',N'PatientMasterId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The patient master.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterContact', @level2type=N'COLUMN',@level2name=N'PatientMasterId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterContact', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Links a patient master to multiple electronic contact numbers or addresses.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterContact'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterContact_Contact]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterContact]'))
ALTER TABLE [hips].[PatientMasterContact]  WITH CHECK ADD  CONSTRAINT [FK_PatientMasterContact_Contact] FOREIGN KEY([ContactId])
REFERENCES [hips].[Contact] ([ContactId])
ON DELETE CASCADE
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterContact_Contact]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterContact]'))
ALTER TABLE [hips].[PatientMasterContact] CHECK CONSTRAINT [FK_PatientMasterContact_Contact]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterContact_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterContact]'))
ALTER TABLE [hips].[PatientMasterContact]  WITH CHECK ADD  CONSTRAINT [FK_PatientMasterContact_PatientMaster] FOREIGN KEY([PatientMasterId])
REFERENCES [hips].[PatientMaster] ([PatientMasterId])
ON DELETE CASCADE
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterContact_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterContact]'))
ALTER TABLE [hips].[PatientMasterContact] CHECK CONSTRAINT [FK_PatientMasterContact_PatientMaster]
GO

