SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[PatientMasterHistory]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[PatientMasterHistory](
	[PatientMasterHistoryId] [int] IDENTITY(1,1) NOT NULL,
	[PatientMasterId] [int] NOT NULL,
	[FromStatePatientId] [varchar](64) NULL,
	[ToStatePatientId] [varchar](64) NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_PatientMasterHistory_1] PRIMARY KEY CLUSTERED 
(
	[PatientMasterHistoryId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterHistory', N'COLUMN',N'PatientMasterHistoryId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'History of changes to PatientMaster record made during merges or moves' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterHistory', @level2type=N'COLUMN',@level2name=N'PatientMasterHistoryId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterHistory', N'COLUMN',N'PatientMasterHistoryId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifier of the PatientMaster record in question' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterHistory', @level2type=N'COLUMN',@level2name=N'PatientMasterId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterHistory', N'COLUMN',N'FromStatePatientId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Previous identifier for the patient, allocated by the EMPI.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterHistory', @level2type=N'COLUMN',@level2name=N'FromStatePatientId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterHistory', N'COLUMN',N'ToStatePatientId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'New identifier for the patient, allocated by the EMPI.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterHistory', @level2type=N'COLUMN',@level2name=N'ToStatePatientId'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterHistory_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterHistory]'))
ALTER TABLE [hips].[PatientMasterHistory]  WITH CHECK ADD  CONSTRAINT [FK_PatientMasterHistory_PatientMaster] FOREIGN KEY([PatientMasterId])
REFERENCES [hips].[PatientMaster] ([PatientMasterId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterHistory_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterHistory]'))
ALTER TABLE [hips].[PatientMasterHistory] CHECK CONSTRAINT [FK_PatientMasterHistory_PatientMaster]
GO

