SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[PatientMasterIhi]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[PatientMasterIhi](
	[PatientMasterId] [int] NOT NULL,
	[Ihi] [varchar](16) NULL,
	[IhiStatusId] [int] NOT NULL,
	[IhiRecordStatusId] [int] NOT NULL,
	[RegisteredGivenName] [varchar](80) NOT NULL,
	[RegisteredFamilyName] [varchar](80) NOT NULL,
	[RegisteredSexId] [int] NOT NULL,
	[DateLastValidated] [datetime] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_PatientMasterIhi] PRIMARY KEY CLUSTERED 
(
	[PatientMasterId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterIhi', N'COLUMN',N'PatientMasterId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to the HIPS Patient Master record.
' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterIhi', @level2type=N'COLUMN',@level2name=N'PatientMasterId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterIhi', N'COLUMN',N'Ihi'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Individual Healthcare Identifier (IHI) assigned to this patient master.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterIhi', @level2type=N'COLUMN',@level2name=N'Ihi'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterIhi', N'COLUMN',N'IhiStatusId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Whether the IHI is Active, Deceased, Retired, Expired or Resolved, and also whether there is a current exception alert on this IHI, such as because it is a potential duplicate or replica.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterIhi', @level2type=N'COLUMN',@level2name=N'IhiStatusId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterIhi', N'COLUMN',N'IhiRecordStatusId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Whether the IHI is Verified, Unverified or Provisional.
' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterIhi', @level2type=N'COLUMN',@level2name=N'IhiRecordStatusId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterIhi', N'COLUMN',N'RegisteredGivenName'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Given name  registered with medicare' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterIhi', @level2type=N'COLUMN',@level2name=N'RegisteredGivenName'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterIhi', N'COLUMN',N'RegisteredFamilyName'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Family name registered with medicare' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterIhi', @level2type=N'COLUMN',@level2name=N'RegisteredFamilyName'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterIhi', N'COLUMN',N'RegisteredSexId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The sex for which the IHI was obtained.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterIhi', @level2type=N'COLUMN',@level2name=N'RegisteredSexId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterIhi', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date that this patient record was inserted into the table' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterIhi', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterIhi', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User account that inserted the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterIhi', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterIhi', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and time that this record was last modified (or as inserted)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterIhi', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterIhi', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The account of the user that last modified (or inserted) this record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterIhi', @level2type=N'COLUMN',@level2name=N'UserModified'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterIhi_IhiRecordStatus]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterIhi]'))
ALTER TABLE [hips].[PatientMasterIhi]  WITH CHECK ADD  CONSTRAINT [FK_PatientMasterIhi_IhiRecordStatus] FOREIGN KEY([IhiRecordStatusId])
REFERENCES [hips].[IhiRecordStatus] ([IhiRecordStatusId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterIhi_IhiRecordStatus]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterIhi]'))
ALTER TABLE [hips].[PatientMasterIhi] CHECK CONSTRAINT [FK_PatientMasterIhi_IhiRecordStatus]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterIhi_IhiStatus]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterIhi]'))
ALTER TABLE [hips].[PatientMasterIhi]  WITH CHECK ADD  CONSTRAINT [FK_PatientMasterIhi_IhiStatus] FOREIGN KEY([IhiStatusId])
REFERENCES [hips].[IhiStatus] ([IhiStatusId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterIhi_IhiStatus]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterIhi]'))
ALTER TABLE [hips].[PatientMasterIhi] CHECK CONSTRAINT [FK_PatientMasterIhi_IhiStatus]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterIhi_Sex]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterIhi]'))
ALTER TABLE [hips].[PatientMasterIhi]  WITH CHECK ADD  CONSTRAINT [FK_PatientMasterIhi_Sex] FOREIGN KEY([RegisteredSexId])
REFERENCES [hips].[Sex] ([SexId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterIhi_Sex]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterIhi]'))
ALTER TABLE [hips].[PatientMasterIhi] CHECK CONSTRAINT [FK_PatientMasterIhi_Sex]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterIhi_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterIhi]'))
ALTER TABLE [hips].[PatientMasterIhi]  WITH CHECK ADD  CONSTRAINT [FK_PatientMasterIhi_PatientMaster] FOREIGN KEY([PatientMasterId])
REFERENCES [hips].[PatientMaster] ([PatientMasterId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterIhi_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterIhi]'))
ALTER TABLE [hips].[PatientMasterIhi] CHECK CONSTRAINT [FK_PatientMasterIhi_PatientMaster]
GO



