SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[PatientMasterName]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[PatientMasterName](
	[PatientMasterNameId] [int] IDENTITY(1,1) NOT NULL,
	[PatientMasterId] [int] NOT NULL,
	[TitleId] [int] NULL,
	[GivenNames] [varchar](80) NOT NULL,
	[FamilyName] [varchar](80) NOT NULL,
	[SuffixId] [int] NULL,
	[NameTypeId] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_PatientMasterName] PRIMARY KEY CLUSTERED 
(
	[PatientMasterNameId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterName', N'COLUMN',N'PatientMasterNameId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies one of the names that a patient is known by.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterName', @level2type=N'COLUMN',@level2name=N'PatientMasterNameId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterName', N'COLUMN',N'PatientMasterId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to the patient master record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterName', @level2type=N'COLUMN',@level2name=N'PatientMasterId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterName', N'COLUMN',N'TitleId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Name title (e.g. Dr, Ms, Miss, Mrs, Mr)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterName', @level2type=N'COLUMN',@level2name=N'TitleId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterName', N'COLUMN',N'GivenNames'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Given names separated by spaces' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterName', @level2type=N'COLUMN',@level2name=N'GivenNames'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterName', N'COLUMN',N'FamilyName'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Family name' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterName', @level2type=N'COLUMN',@level2name=N'FamilyName'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterName', N'COLUMN',N'SuffixId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Name suffix (e.g. Jr, Sr)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterName', @level2type=N'COLUMN',@level2name=N'SuffixId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterName', N'COLUMN',N'NameTypeId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Type of name (Registered, Current or Other)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterName', @level2type=N'COLUMN',@level2name=N'NameTypeId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterName', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date that this patient record was inserted into the table' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterName', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterName', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User account that inserted the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterName', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterName', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and time that this record was last modified (or as inserted)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterName', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PatientMasterName', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The account of the user that last modified (or inserted) this record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PatientMasterName', @level2type=N'COLUMN',@level2name=N'UserModified'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterName_NameType]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterName]'))
ALTER TABLE [hips].[PatientMasterName]  WITH CHECK ADD  CONSTRAINT [FK_PatientMasterName_NameType] FOREIGN KEY([NameTypeId])
REFERENCES [hips].[NameType] ([NameTypeId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterName_NameType]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterName]'))
ALTER TABLE [hips].[PatientMasterName] CHECK CONSTRAINT [FK_PatientMasterName_NameType]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterName_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterName]'))
ALTER TABLE [hips].[PatientMasterName]  WITH CHECK ADD  CONSTRAINT [FK_PatientMasterName_PatientMaster] FOREIGN KEY([TitleId])
REFERENCES [hips].[Title] ([TitleId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterName_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterName]'))
ALTER TABLE [hips].[PatientMasterName] CHECK CONSTRAINT [FK_PatientMasterName_PatientMaster]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterName_PatientMaster1]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterName]'))
ALTER TABLE [hips].[PatientMasterName]  WITH CHECK ADD  CONSTRAINT [FK_PatientMasterName_PatientMaster1] FOREIGN KEY([PatientMasterId])
REFERENCES [hips].[PatientMaster] ([PatientMasterId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterName_PatientMaster1]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterName]'))
ALTER TABLE [hips].[PatientMasterName] CHECK CONSTRAINT [FK_PatientMasterName_PatientMaster1]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterName_Suffix]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterName]'))
ALTER TABLE [hips].[PatientMasterName]  WITH CHECK ADD  CONSTRAINT [FK_PatientMasterName_Suffix] FOREIGN KEY([SuffixId])
REFERENCES [hips].[Suffix] ([SuffixId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterName_Suffix]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterName]'))
ALTER TABLE [hips].[PatientMasterName] CHECK CONSTRAINT [FK_PatientMasterName_Suffix]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterName_Title]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterName]'))
ALTER TABLE [hips].[PatientMasterName]  WITH CHECK ADD  CONSTRAINT [FK_PatientMasterName_Title] FOREIGN KEY([TitleId])
REFERENCES [hips].[Title] ([TitleId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PatientMasterName_Title]') AND parent_object_id = OBJECT_ID(N'[hips].[PatientMasterName]'))
ALTER TABLE [hips].[PatientMasterName] CHECK CONSTRAINT [FK_PatientMasterName_Title]
GO

