SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[PcehrAudit]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[PcehrAudit](
	[PcehrAuditId] [int] IDENTITY(1,1) NOT NULL,
	[PatientMasterId] [int] NOT NULL,
	[ServiceName] [varchar](256) NOT NULL,
	[ServiceMessage] [varchar](max) NOT NULL,
	[Request] [xml] NULL,
	[Response] [xml] NULL,
	[Ihi] [varchar](16) NOT NULL,
	[HpiO] [varchar](16) NOT NULL,
	[UserName] [varchar](256) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_PcehrAudit] PRIMARY KEY CLUSTERED 
(
	[PcehrAuditId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PcehrAudit_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[PcehrAudit]'))
ALTER TABLE [hips].[PcehrAudit]  WITH CHECK ADD  CONSTRAINT [FK_PcehrAudit_PatientMaster] FOREIGN KEY([PatientMasterId])
REFERENCES [hips].[PatientMaster] ([PatientMasterId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PcehrAudit_PatientMaster]') AND parent_object_id = OBJECT_ID(N'[hips].[PcehrAudit]'))
ALTER TABLE [hips].[PcehrAudit] CHECK CONSTRAINT [FK_PcehrAudit_PatientMaster]
GO

