SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[PcehrMessageQueue]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[PcehrMessageQueue](
	[PcehrMessageQueueId] [int] IDENTITY(1,1) NOT NULL,
	[QueueOperationId] [int] NOT NULL,
	[QueueStatusId] [int] NOT NULL,
	[EpisodeId] [int] NULL,
	[SourceSystemSetId] [varchar](128) NULL,
	[SourceSystemDocumentId] [varchar](128) NULL,
	[SerialisedObject] [varbinary](max) NOT NULL,
	[Request] [xml] NULL,
	[Response] [xml] NULL,
	[Details] [varchar](max) NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_PcehrMessageQueue] PRIMARY KEY CLUSTERED 
(
	[PcehrMessageQueueId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PcehrMessageQueue_QueueOperation]') AND parent_object_id = OBJECT_ID(N'[hips].[PcehrMessageQueue]'))
ALTER TABLE [hips].[PcehrMessageQueue]  WITH CHECK ADD  CONSTRAINT [FK_PcehrMessageQueue_QueueOperation] FOREIGN KEY([QueueOperationId])
REFERENCES [hips].[QueueOperation] ([QueueOperationId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PcehrMessageQueue_QueueOperation]') AND parent_object_id = OBJECT_ID(N'[hips].[PcehrMessageQueue]'))
ALTER TABLE [hips].[PcehrMessageQueue] CHECK CONSTRAINT [FK_PcehrMessageQueue_QueueOperation]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PcehrMessageQueue_QueueStatus]') AND parent_object_id = OBJECT_ID(N'[hips].[PcehrMessageQueue]'))
ALTER TABLE [hips].[PcehrMessageQueue]  WITH CHECK ADD  CONSTRAINT [FK_PcehrMessageQueue_QueueStatus] FOREIGN KEY([QueueStatusId])
REFERENCES [hips].[QueueStatus] ([QueueStatusId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PcehrMessageQueue_QueueStatus]') AND parent_object_id = OBJECT_ID(N'[hips].[PcehrMessageQueue]'))
ALTER TABLE [hips].[PcehrMessageQueue] CHECK CONSTRAINT [FK_PcehrMessageQueue_QueueStatus]
GO

