SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[RemovalReason]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[RemovalReason](
	[RemovalReasonId] [int] IDENTITY(1,1) NOT NULL,
	[Description] [varchar](50) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_RemovalReason] PRIMARY KEY CLUSTERED 
(
	[RemovalReasonId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'RemovalReason', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Description (e.g. Withdrawn, Elect to Remove, Incorrect Identity)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'RemovalReason', @level2type=N'COLUMN',@level2name=N'Description'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'RemovalReason', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Reason why a document version was removed from PCEHR' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'RemovalReason'
GO

