SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[RemoveAudit]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[RemoveAudit](
	[RemoveAuditId] [int] IDENTITY(1,1) NOT NULL,
	[ClinicalDocumentId] [int] NOT NULL,
	[RemovalReasonId] [int] NOT NULL,
	[AuditInformation] [varbinary](MAX) NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_RemoveAudit] PRIMARY KEY CLUSTERED 
(
	[RemoveAuditId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'RemoveAudit', N'COLUMN',N'RemoveAuditId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Primary Key' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'RemoveAudit', @level2type=N'COLUMN',@level2name=N'RemoveAuditId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'RemoveAudit', N'COLUMN',N'ClinicalDocumentId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to the ClinicalDocument that was removed from the PCEHR system' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'RemoveAudit', @level2type=N'COLUMN',@level2name=N'ClinicalDocumentId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'RemoveAudit', N'COLUMN',N'RemovalReasonId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Reason for removal from the PCEHR system' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'RemoveAudit', @level2type=N'COLUMN',@level2name=N'RemovalReasonId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'RemoveAudit', N'COLUMN',N'AuditInformation'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Supplied audit information about the request for removal' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'RemoveAudit', @level2type=N'COLUMN',@level2name=N'AuditInformation'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'RemoveAudit', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date that this record was inserted into the table' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'RemoveAudit', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'RemoveAudit', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User account that inserted the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'RemoveAudit', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'RemoveAudit', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and time that this record was last modified (or as inserted)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'RemoveAudit', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'RemoveAudit', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The account of the user that last modified (or inserted) this record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'RemoveAudit', @level2type=N'COLUMN',@level2name=N'UserModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'RemoveAudit', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Record that a user removed a document from the PCEHR.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'RemoveAudit'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_RemoveAudit_ClinicalDocument]') AND parent_object_id = OBJECT_ID(N'[hips].[RemoveAudit]'))
ALTER TABLE [hips].[RemoveAudit]  WITH CHECK ADD  CONSTRAINT [FK_RemoveAudit_ClinicalDocument] FOREIGN KEY([ClinicalDocumentId])
REFERENCES [hips].[ClinicalDocument] ([ClinicalDocumentId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_RemoveAudit_ClinicalDocument]') AND parent_object_id = OBJECT_ID(N'[hips].[RemoveAudit]'))
ALTER TABLE [hips].[RemoveAudit] CHECK CONSTRAINT [FK_RemoveAudit_ClinicalDocument]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_RemoveAudit_RemovalReason]') AND parent_object_id = OBJECT_ID(N'[hips].[RemoveAudit]'))
ALTER TABLE [hips].[RemoveAudit]  WITH CHECK ADD  CONSTRAINT [FK_RemoveAudit_RemovalReason] FOREIGN KEY([RemovalReasonId])
REFERENCES [hips].[RemovalReason] ([RemovalReasonId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_RemoveAudit_RemovalReason]') AND parent_object_id = OBJECT_ID(N'[hips].[RemoveAudit]'))
ALTER TABLE [hips].[RemoveAudit] CHECK CONSTRAINT [FK_RemoveAudit_RemovalReason]
GO

