SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[StreetSuffixTypeCode]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[StreetSuffixTypeCode](
	[StreetSuffixTypeId] [int] NOT NULL,
	[CodeSystemId] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_StreetSuffixTypeCode] PRIMARY KEY CLUSTERED 
(
	[StreetSuffixTypeId] ASC,
	[CodeSystemId] ASC  
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetSuffixTypeCode', N'COLUMN',N'StreetSuffixTypeId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'StreetSuffixType' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetSuffixTypeCode', @level2type=N'COLUMN',@level2name=N'StreetSuffixTypeId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetSuffixTypeCode', N'COLUMN',N'CodeSystemId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Type of identifier' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetSuffixTypeCode', @level2type=N'COLUMN',@level2name=N'CodeSystemId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetSuffixTypeCode', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was created' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetSuffixTypeCode', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetSuffixTypeCode', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that created the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetSuffixTypeCode', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetSuffixTypeCode', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was modified' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetSuffixTypeCode', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetSuffixTypeCode', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that modified the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetSuffixTypeCode', @level2type=N'COLUMN',@level2name=N'UserModified'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_StreetSuffixTypeCode_CodeSystem]') AND parent_object_id = OBJECT_ID(N'[hips].[StreetSuffixTypeCode]'))
ALTER TABLE [hips].[StreetSuffixTypeCode]  WITH CHECK ADD  CONSTRAINT [FK_StreetSuffixTypeCode_CodeSystem] FOREIGN KEY([CodeSystemId])
REFERENCES [hips].[CodeSystem] ([CodeSystemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_StreetSuffixTypeCode_CodeSystem]') AND parent_object_id = OBJECT_ID(N'[hips].[StreetSuffixTypeCode]'))
ALTER TABLE [hips].[StreetSuffixTypeCode] CHECK CONSTRAINT [FK_StreetSuffixTypeCode_CodeSystem]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_StreetSuffixTypeCode_StreetSuffixType]') AND parent_object_id = OBJECT_ID(N'[hips].[StreetSuffixTypeCode]'))
ALTER TABLE [hips].[StreetSuffixTypeCode]  WITH CHECK ADD  CONSTRAINT [FK_StreetSuffixTypeCode_StreetSuffixType] FOREIGN KEY([StreetSuffixTypeId])
REFERENCES [hips].[StreetSuffixType] ([StreetSuffixTypeId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_StreetSuffixTypeCode_StreetSuffixType]') AND parent_object_id = OBJECT_ID(N'[hips].[StreetSuffixTypeCode]'))
ALTER TABLE [hips].[StreetSuffixTypeCode] CHECK CONSTRAINT [FK_StreetSuffixTypeCode_StreetSuffixType]
GO

