SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[SystemErrorLog]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[SystemErrorLog](
	[SystemErrorLogId] [int] IDENTITY(1,1) NOT NULL,
	[LogMessageId] [int] NOT NULL,
	[Message] [varchar](200) NOT NULL,
	[ExceptionMessage] [varchar](500) NULL,	
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
 CONSTRAINT [PK_SystemErrorLog] PRIMARY KEY CLUSTERED 
(
	[SystemErrorLogId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_SystemErrorLog_LogMessage]') AND parent_object_id = OBJECT_ID(N'[hips].[SystemErrorLog]'))
ALTER TABLE [hips].[SystemErrorLog]  WITH CHECK ADD  CONSTRAINT [FK_SystemErrorLog_LogMessage] FOREIGN KEY([LogMessageId])
REFERENCES [hips].[LogMessage] ([LogMessageId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_SystemErrorLog_LogMessage]') AND parent_object_id = OBJECT_ID(N'[hips].[SystemErrorLog]'))
ALTER TABLE [hips].[SystemErrorLog] CHECK CONSTRAINT [FK_SystemErrorLog_LogMessage]
GO
SET ANSI_PADDING OFF
GO

