IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[hips].[MonitoringMergeInfoMessages]'))
DROP VIEW [hips].[MonitoringMergeInfoMessages]
GO
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE VIEW [hips].[MonitoringMergeInfoMessages]
AS
	SELECT Message, ExceptionMessage, DateCreated, LogMessage
	FROM hips.[MonitoringSyslog]
		WHERE MonitorTabId = 2
		AND DATEDIFF(hour, DateCreated, SYSDATETIME())<=24
		AND (
		ExceptionMessage LIKE '%Only the survivor was found for enterprise merge%'
		OR ExceptionMessage LIKE '%Neither patient was found for enterprise merge%'
		OR ExceptionMessage LIKE '%Source patient not found for merge%'
		OR ExceptionMessage LIKE '%Source patient not found for move%'
		OR ExceptionMessage LIKE '%Episode not found for move visit%'
		)

GO

