/****** Object:  View [hips].[MonitoringSyslog]     ******/
IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[hips].[MonitoringSyslog]'))
DROP VIEW [hips].[MonitoringSyslog]
GO

/****** Object:  View [hips].[MonitoringSyslog]    ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE VIEW [hips].[MonitoringSyslog]
AS

	SELECT  sel.*, 
			mt.MonitorTabId, 
			mt.description,
			lm.Class,
			lm.Method,
			lm.description AS logdescription,
			'(#'+CAST(lm.LogMessageId AS VARCHAR)+') '+ lm.description+'  ['+lm.Class+':'+lm.Method+']' AS LogMessage
	FROM hips.SystemErrorLog sel WITH (NOLOCK)
	JOIN hips.MonitorTabMessage mtm WITH (NOLOCK) ON sel.LogMessageId = mtm.LogMessageId
	JOIN hips.MonitorTab mt WITH (NOLOCK) ON mt.MonitorTabId = mtm.MonitorTabId 
	JOIN hips.LogMessage lm WITH (NOLOCK) ON lm.LogMessageId = mtm.LogMessageId

GO

