IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[hips].[MonitoringUploadedDocuments]'))
DROP VIEW [hips].[MonitoringUploadedDocuments]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE VIEW [hips].[MonitoringUploadedDocuments]
AS
	SELECT  UploadedDate "Upload DateTime",
        SUBSTRING(SourceSystemDocumentId,
                  CHARINDEX('^', SourceSystemDocumentId) + 1,
                  LEN(SourceSystemDocumentId)) "Source Doc ID" ,
        CodeSystem.Description "Document ID Type" ,
        PcehrAudit.UserName "Sender Name" ,
        hospital.description "Hospital" ,
        HospitalPatient.Mrn "MRN" ,
        Episode.SourceSystemEpisodeId "Visit Number" ,
        Episode.AdmissionDate "Admission DateTime" ,
        Episode.DischargeDate "Discharge DateTime"
	FROM    hips.ClinicalDocumentVersion
			INNER JOIN hips.ClinicalDocument ON hips.ClinicalDocument.ClinicalDocumentId = hips.ClinicalDocumentVersion.ClinicalDocumentId
			INNER JOIN hips.CodeSystem ON hips.CodeSystem.Oid = SUBSTRING(hips.ClinicalDocumentVersion.SourceSystemDocumentId,1, LEN(hips.CodeSystem.Oid)) 
			INNER JOIN hips.Episode ON hips.Episode.EpisodeId = hips.ClinicalDocument.EpisodeId
			INNER JOIN hips.HospitalPatient ON hips.HospitalPatient.PatientId = hips.Episode.PatientId
			INNER JOIN hips.Hospital ON hips.Hospital.HospitalId = hips.HospitalPatient.HospitalId
			INNER JOIN hips.PatientMaster ON hips.PatientMaster.PatientMasterId = hips.HospitalPatient.PatientMasterId
			INNER JOIN hips.PatientMasterName ON hips.PatientMasterName.PatientMasterId = hips.PatientMaster.PatientMasterId
												 AND NameTypeId = 2
			LEFT JOIN hips.PcehrAudit ON hips.PcehrAudit.PatientMasterId = hips.PatientMaster.PatientMasterId
										 AND PcehrAudit.ServiceName = 'Upload Document'
										 AND ABS(DATEDIFF(ss,
														  PCehrAudit.DateCreated,
														  ClinicalDocumentVersion.DateCreated)) < 2
			LEFT JOIN hips.PatientMasterIhi ON hips.PatientMasterIhi.PatientMasterId = hips.PatientMaster.PatientMasterId
	WHERE DATEDIFF(day, ClinicalDocumentVersion.DateCreated, SYSDATETIME())<=7

GO

