﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Data.SqlClient;
using System.Configuration;
using System.Globalization;
using System.Reflection;

namespace HipsMonitoring
{
    public partial class DashboardForm : Form
    {
        private const int MAX_WINDOW_WIDTH = 1920;
        private const int MAX_WINDOW_HEIGHT = 1020;
        private const int MIN_WINDOW_WIDTH = 988;
        private const int MIN_WINDOW_HEIGHT = 391;
        private const int MIN_WINDOW_SHOWERROR_HEIGHT = 581;
        private const int LOG_COLUMN_WIDTH = 90;

        private const string RED = "RED";
        private const string ORANGE = "ORANGE";
        private const string GREEN = "GREEN";


        
        private const int DATAVIEW_FIXED_WIDTH = 957;
        bool showSnooze = false;
        bool snoozing = false;

        bool shown = false;
        bool alertAcknowledgedIhiConnFailure = false;
        bool alertAcknowledgedPcehrConnFailure = false;
        bool alertAcknowledgedPasError = false;
        bool alertAcknowledgedPasCount = false;
        bool alertAcknowledgedPcehrQueueFailure = false;
        bool alertAcknowledgedPcehrQueuePending = false;
        bool alertAcknowledgedConsentServiceFailure = false;


        private bool hipsErrorsTabShow;
        private bool hipsInfoTabShow;
        private bool ihiConnectionErrorsTabShow;
        private bool pcehrErrorsTabShow;
        private bool pcehrInfoTabShow;
        private bool backgroundProcessorTabShow;
        private bool msmqInfoTabShow;
        private bool pumaErrorsTabShow;
        private bool pcehrUploadErrorsTabShow;
        private bool mergeTabShow;
        private bool pcehrUploadedDocumentTabShow;
        private bool ihiInfoTabShow;

        private string savedPath = null;
        private FolderBrowserDialog folderBrowserDialog;

        HipsInformation hipsInfo;
        private DataGridView mainGridView = new DataGridView();
        private BindingSource mainGridSource = new BindingSource();


        private DataGridView HIPSErrorsView = new DataGridView();
        private BindingSource HIPSErrorsSource = new BindingSource();

        private DataGridView HIPSInfoView = new DataGridView();
        private BindingSource HIPSInfoSource = new BindingSource();

        private DataGridView MergeInfoView = new DataGridView();
        private BindingSource MergeInfoSource = new BindingSource();

        private DataGridView ihiConnectionErrorsView = new DataGridView();
        private BindingSource ihiConnectionErrorsSource = new BindingSource();

        private DataGridView ihiLookupInfoView = new DataGridView();
        private BindingSource ihiLookupInfoSource = new BindingSource();
                
        private DataGridView pcehrErrorsView = new DataGridView();
        private BindingSource pcehrErrorsSource = new BindingSource();
        
        private DataGridView pcehrInfoView = new DataGridView();
        private BindingSource pcehrInfoSource = new BindingSource();

        private DataGridView backgroundProcessorView = new DataGridView();
        private BindingSource backgroundProcessorSource = new BindingSource();

        private DataGridView msmqInfoView = new DataGridView();
        private BindingSource msmqInfoSource = new BindingSource();

        private DataGridView pumaErrorView = new DataGridView();
        private BindingSource pumaErrorSource = new BindingSource();

        private DataGridView pcehrUploadErrorView = new DataGridView();
        private BindingSource pcehrUploadErrorSource = new BindingSource();

        private DataGridView pcehrUploadedDocumentsView = new DataGridView();
        private BindingSource pcehrUploadedDocumentsSource = new BindingSource();

        private decimal lastIhiConnectionFailurePercentage = -1;
        private decimal lastPcehrConnectionFailurePercentage = -1;
        private int lastPasMessageCount = -1;
        private int lastPasErrorMessageCount = -1;
        private int lastPcehrPendingCount = -1;
        private int lastPcehrFailedCount = -1;
        private int lastConsentPatientsChecked = -1;

        private bool orangeWarning = false;
        private bool redError = false;
        private bool greenFlag = false;

        private List<Tuple<int, string, string>> CheckList = new List<Tuple<int, string, string>>(3);  

        public DashboardForm()
        {

            this.DoubleBuffered = true;

            this.SetStyle(
                System.Windows.Forms.ControlStyles.UserPaint | 
                System.Windows.Forms.ControlStyles.AllPaintingInWmPaint | 
                System.Windows.Forms.ControlStyles.OptimizedDoubleBuffer, 
                true);

            bool.TryParse(ConfigurationManager.AppSettings["HipsErrorsTab"], out hipsErrorsTabShow);
            bool.TryParse(ConfigurationManager.AppSettings["HipsInfoTab"], out hipsInfoTabShow);
            bool.TryParse(ConfigurationManager.AppSettings["IhiConnectionErrorsTab"], out ihiConnectionErrorsTabShow);
            bool.TryParse(ConfigurationManager.AppSettings["PcehrErrorsTab"], out pcehrErrorsTabShow);
            bool.TryParse(ConfigurationManager.AppSettings["PcehrInfoTab"], out pcehrInfoTabShow);
            bool.TryParse(ConfigurationManager.AppSettings["BackgroundProcessorTab"], out backgroundProcessorTabShow);
            bool.TryParse(ConfigurationManager.AppSettings["MsmqInfoTab"], out msmqInfoTabShow);
            bool.TryParse(ConfigurationManager.AppSettings["PumaErrorsTab"], out pumaErrorsTabShow);
            bool.TryParse(ConfigurationManager.AppSettings["PcehrUploadErrorsTab"], out pcehrUploadErrorsTabShow);
            bool.TryParse(ConfigurationManager.AppSettings["MergeTab"], out mergeTabShow);
            bool.TryParse(ConfigurationManager.AppSettings["IhiInfoTab"], out ihiInfoTabShow);
            bool.TryParse(ConfigurationManager.AppSettings["PcehrUploadedDocumentTab"], out pcehrUploadedDocumentTabShow);


            this.Hide();
            InitializeComponent();
            listDisplayCount.SelectedIndex = 0;

            if (!hipsErrorsTabShow)
            {
                this.messageTab.Controls.Remove(this.hipsErrorsTab);
            }

            if (!hipsInfoTabShow)
            {
                this.messageTab.Controls.Remove(this.hipsInfoTab);
            }

            if (!mergeTabShow)
            {
                this.messageTab.Controls.Remove(this.mergeInfoTab);
            }

            if (!ihiConnectionErrorsTabShow)
            {
                this.messageTab.Controls.Remove(this.ihiConnectionErrorsTab);
            }

            if (!ihiInfoTabShow)
            {
                this.messageTab.Controls.Remove(this.ihiInfoTab);
            }

            if (!pcehrErrorsTabShow)
            {
                this.messageTab.Controls.Remove(this.pcehrErrorsTab);
            }

            if (!pcehrInfoTabShow)
            {
                this.messageTab.Controls.Remove(this.pcehrInfoTab);
            }

            if (!pcehrUploadErrorsTabShow)
            {
                displayAllErrorsLabel.Hide();
                this.messageTab.Controls.Remove(this.pcehrUploadErrorsTab);
            }

            if (!msmqInfoTabShow)
            {
                this.messageTab.Controls.Remove(this.msmqInfoTab);
            }

            if (!pumaErrorsTabShow)
            {
                this.messageTab.Controls.Remove(this.pumaErrorsTab);
            }

            if (!backgroundProcessorTabShow)
            {
                this.messageTab.Controls.Remove(this.backgroundProcessorTab);
            }

            if (!pcehrUploadedDocumentTabShow)
            {
                this.messageTab.Controls.Remove(this.pcehrUploadedDocumentTab);
                displaysLastDaysLabel.Hide();
            }


            int alertTimerIntervalMinutes = 1;
            Int32.TryParse(ConfigurationManager.AppSettings["AlertTimerIntervalMinutes"], out alertTimerIntervalMinutes);
            if (alertTimerIntervalMinutes < 1)
            {
                alertTimerIntervalMinutes = 1;
            }
            else if (alertTimerIntervalMinutes > 10)
            {
                alertTimerIntervalMinutes = 10;
            }
            this.ihiAlertTimer.Interval = alertTimerIntervalMinutes * 60 * 1000;


            Rectangle r = Screen.PrimaryScreen.WorkingArea;
            this.StartPosition = FormStartPosition.Manual;
            this.Width = MIN_WINDOW_WIDTH;
            this.Height = MIN_WINDOW_HEIGHT;

            this.MaximumSize = new System.Drawing.Size(MAX_WINDOW_WIDTH, MIN_WINDOW_HEIGHT);
            this.Location = new Point(Screen.PrimaryScreen.WorkingArea.Width - this.Width, Screen.PrimaryScreen.WorkingArea.Height - this.Height);

        }

        private void hideToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.Hide();
        }

        private void showToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.Show();
            this.Activate();
            this.BringToFront();
            
        }

        private void DashboardForm_Load(object sender, EventArgs e)
        {
            try
            {
                hipsInfo = new HipsInformation();
                // initialise to 10 minutes for IHI
                hipsInfo.IhiRefreshTime = 60;
                // pas message refresh time
                hipsInfo.PasRefreshTime = 10;
                // how many minutes to check for IHI connection Errors
                hipsInfo.IhiConnectionTime = 60;
                // how many hours to go back for the IhiLookupTime Average
                hipsInfo.HoursForRollingAverage = 2;
                //how many hours to view pas message failures
                hipsInfo.PasFailureHours = 8;
                hipsInfo.PcehrFailedDays = 7;

                notifyIcon.Text = "HIPS Monitor Initializing...";
                notifyIcon.Icon = HipsMonitoring.Properties.Resources.TimeIcon;


                setDataSources();

                #region Tab Initialisation

                if (hipsErrorsTabShow) 
                { 
                    this.hipsErrorsTab.Controls.Add(this.HIPSErrorsView);
                }

                if (hipsInfoTabShow)
                {
                    this.hipsInfoTab.Controls.Add(this.HIPSInfoView);
                }
                
                if (mergeTabShow)
                {
                    this.mergeInfoTab.Controls.Add(this.MergeInfoView);
                }
                
                if (ihiConnectionErrorsTabShow)
                {
                    this.ihiConnectionErrorsTab.Controls.Add(this.ihiConnectionErrorsView);
                }

                if (ihiInfoTabShow)
                {
                    this.ihiInfoTab.Controls.Add(this.ihiLookupInfoView);
                }
                
                if (pcehrErrorsTabShow)
                {
                    this.pcehrErrorsTab.Controls.Add(this.pcehrErrorsView);
                }
                
                if (pcehrInfoTabShow)
                {
                    this.pcehrInfoTab.Controls.Add(this.pcehrInfoView);
                }

                if (backgroundProcessorTabShow)
                {
                    this.backgroundProcessorTab.Controls.Add(this.backgroundProcessorView);
                }
                
                if (msmqInfoTabShow)
                {
                    this.msmqInfoTab.Controls.Add(this.msmqInfoView);
                }

                if (pumaErrorsTabShow)
                {
                    this.pumaErrorsTab.Controls.Add(this.pumaErrorView);
                }

                if (pcehrUploadErrorsTabShow)
                {
                    this.pcehrUploadErrorsTab.Controls.Add(this.pcehrUploadErrorView);
                }

                if (pcehrUploadedDocumentTabShow)
                {
                    this.pcehrUploadedDocumentTab.Controls.Add(this.pcehrUploadedDocumentsView);
                }
                

                // Setup the HIPS Error Data Grid View
                if (hipsErrorsTabShow)
                {
                    this.HIPSErrorsView.AllowUserToAddRows = false;
                    this.HIPSErrorsView.AllowUserToDeleteRows = false;
                    this.HIPSErrorsView.AllowUserToResizeColumns = true;
                    this.HIPSErrorsView.AllowUserToResizeRows = false;
                    this.HIPSErrorsView.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left)
                    | System.Windows.Forms.AnchorStyles.Right | System.Windows.Forms.AnchorStyles.Bottom)));
                    this.HIPSErrorsView.AutoSizeColumnsMode = System.Windows.Forms.DataGridViewAutoSizeColumnsMode.Fill;
                    this.HIPSErrorsView.RowHeadersVisible = false;
                    this.HIPSErrorsView.ColumnHeadersHeightSizeMode = System.Windows.Forms.DataGridViewColumnHeadersHeightSizeMode.AutoSize;
                    this.HIPSErrorsView.MultiSelect = true;
                    this.HIPSErrorsView.Name = "HIPSErrorsView";
                    this.HIPSErrorsView.ReadOnly = true;
                    this.HIPSErrorsView.RowHeadersWidthSizeMode = System.Windows.Forms.DataGridViewRowHeadersWidthSizeMode.AutoSizeToDisplayedHeaders;
                    this.HIPSErrorsView.SelectionMode = System.Windows.Forms.DataGridViewSelectionMode.FullRowSelect;
                    this.HIPSErrorsView.Size = new System.Drawing.Size(557, 90);
                    this.HIPSErrorsView.Width = DATAVIEW_FIXED_WIDTH;
                    this.HIPSErrorsView.Height = this.hipsErrorsTab.Height;
                    this.HIPSErrorsView.ScrollBars = ScrollBars.Both;
                    this.HIPSErrorsView.TabStop = true;
                    this.HIPSErrorsView.TabIndex = 2;
                }

                // Setup the HIPS Info Data Grid View
                if (hipsInfoTabShow)
                {
                    this.HIPSInfoView.AllowUserToAddRows = false;
                    this.HIPSInfoView.AllowUserToDeleteRows = false;
                    this.HIPSInfoView.AllowUserToResizeColumns = true;
                    this.HIPSInfoView.AllowUserToResizeRows = false;
                    this.HIPSInfoView.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left)
                    | System.Windows.Forms.AnchorStyles.Right | System.Windows.Forms.AnchorStyles.Bottom)));
                    this.HIPSInfoView.AutoSizeColumnsMode = System.Windows.Forms.DataGridViewAutoSizeColumnsMode.Fill;
                    this.HIPSInfoView.RowHeadersVisible = false;
                    this.HIPSInfoView.ColumnHeadersHeightSizeMode = System.Windows.Forms.DataGridViewColumnHeadersHeightSizeMode.AutoSize;
                    this.HIPSInfoView.MultiSelect = true;
                    this.HIPSInfoView.Name = "HIPSInfoView";
                    this.HIPSInfoView.ReadOnly = true;
                    this.HIPSInfoView.RowHeadersWidthSizeMode = System.Windows.Forms.DataGridViewRowHeadersWidthSizeMode.AutoSizeToDisplayedHeaders;
                    this.HIPSInfoView.SelectionMode = System.Windows.Forms.DataGridViewSelectionMode.FullRowSelect;
                    this.HIPSInfoView.Size = new System.Drawing.Size(557, 90);
                    this.HIPSInfoView.Width = DATAVIEW_FIXED_WIDTH;
                    this.HIPSInfoView.Height = this.hipsInfoTab.Height;
                    this.HIPSInfoView.ScrollBars = ScrollBars.Both;
                    this.HIPSInfoView.TabStop = true;
                    this.HIPSInfoView.TabIndex = 2;
                }

                // Setup the Merge Info Data Grid View
                if (mergeTabShow)
                {
                    this.MergeInfoView.AllowUserToAddRows = false;
                    this.MergeInfoView.AllowUserToDeleteRows = false;
                    this.MergeInfoView.AllowUserToResizeColumns = true;
                    this.MergeInfoView.AllowUserToResizeRows = false;
                    this.MergeInfoView.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left)
                    | System.Windows.Forms.AnchorStyles.Right | System.Windows.Forms.AnchorStyles.Bottom)));
                    this.MergeInfoView.AutoSizeColumnsMode = System.Windows.Forms.DataGridViewAutoSizeColumnsMode.Fill;
                    this.MergeInfoView.RowHeadersVisible = false;
                    this.MergeInfoView.ColumnHeadersHeightSizeMode = System.Windows.Forms.DataGridViewColumnHeadersHeightSizeMode.AutoSize;
                    this.MergeInfoView.MultiSelect = true;
                    this.MergeInfoView.Name = "MergeInfoView";
                    this.MergeInfoView.ReadOnly = true;
                    this.MergeInfoView.RowHeadersWidthSizeMode = System.Windows.Forms.DataGridViewRowHeadersWidthSizeMode.AutoSizeToDisplayedHeaders;
                    this.MergeInfoView.SelectionMode = System.Windows.Forms.DataGridViewSelectionMode.FullRowSelect;
                    this.MergeInfoView.Size = new System.Drawing.Size(557, 90);
                    this.MergeInfoView.Width = DATAVIEW_FIXED_WIDTH;
                    this.MergeInfoView.Height = this.mergeInfoTab.Height;
                    this.MergeInfoView.ScrollBars = ScrollBars.Both;
                    this.MergeInfoView.TabStop = true;
                    this.MergeInfoView.TabIndex = 2;
                }

                // Setup the IHI Lookup Data Grid View
                if (ihiInfoTabShow)
                {
                    this.ihiLookupInfoView.AllowUserToAddRows = false;
                    this.ihiLookupInfoView.AllowUserToDeleteRows = false;
                    this.ihiLookupInfoView.AllowUserToResizeColumns = true;
                    this.ihiLookupInfoView.AllowUserToResizeRows = false;
                    this.ihiLookupInfoView.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left)
                    | System.Windows.Forms.AnchorStyles.Right | System.Windows.Forms.AnchorStyles.Bottom)));
                    this.ihiLookupInfoView.AutoSizeColumnsMode = System.Windows.Forms.DataGridViewAutoSizeColumnsMode.Fill;
                    this.ihiLookupInfoView.RowHeadersVisible = false;
                    this.ihiLookupInfoView.ColumnHeadersHeightSizeMode = System.Windows.Forms.DataGridViewColumnHeadersHeightSizeMode.AutoSize;
                    this.ihiLookupInfoView.MultiSelect = true;
                    this.ihiLookupInfoView.Name = "ihiLookupInfoView";
                    this.ihiLookupInfoView.ReadOnly = true;
                    this.ihiLookupInfoView.RowHeadersWidthSizeMode = System.Windows.Forms.DataGridViewRowHeadersWidthSizeMode.AutoSizeToDisplayedHeaders;
                    this.ihiLookupInfoView.SelectionMode = System.Windows.Forms.DataGridViewSelectionMode.FullRowSelect;
                    this.ihiLookupInfoView.Size = new System.Drawing.Size(557, 90);
                    this.ihiLookupInfoView.Width = DATAVIEW_FIXED_WIDTH;
                    this.ihiLookupInfoView.Height = this.ihiInfoTab.Height;
                    this.ihiLookupInfoView.ScrollBars = ScrollBars.Both;
                    this.ihiLookupInfoView.TabStop = true;
                    this.ihiLookupInfoView.TabIndex = 2;
                }

                // Setup the IHI Connection Errors Data Grid View
                if (ihiConnectionErrorsTabShow)
                {
                    this.ihiConnectionErrorsView.AllowUserToAddRows = false;
                    this.ihiConnectionErrorsView.AllowUserToDeleteRows = false;
                    this.ihiConnectionErrorsView.AllowUserToResizeColumns = true;
                    this.ihiConnectionErrorsView.AllowUserToResizeRows = false;
                    this.ihiConnectionErrorsView.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left)
                    | System.Windows.Forms.AnchorStyles.Right | System.Windows.Forms.AnchorStyles.Bottom)));
                    this.ihiConnectionErrorsView.AutoSizeColumnsMode = System.Windows.Forms.DataGridViewAutoSizeColumnsMode.Fill;
                    this.ihiConnectionErrorsView.RowHeadersVisible = false;
                    this.ihiConnectionErrorsView.ColumnHeadersHeightSizeMode = System.Windows.Forms.DataGridViewColumnHeadersHeightSizeMode.AutoSize;
                    this.ihiConnectionErrorsView.MultiSelect = true;
                    this.ihiConnectionErrorsView.Name = "ihiConnectionErrorsView";
                    this.ihiConnectionErrorsView.ReadOnly = true;
                    this.ihiConnectionErrorsView.RowHeadersWidthSizeMode = System.Windows.Forms.DataGridViewRowHeadersWidthSizeMode.AutoSizeToDisplayedHeaders;
                    this.ihiConnectionErrorsView.SelectionMode = System.Windows.Forms.DataGridViewSelectionMode.FullRowSelect;
                    this.ihiConnectionErrorsView.Size = new System.Drawing.Size(557, 90);
                    this.ihiConnectionErrorsView.Width = DATAVIEW_FIXED_WIDTH;
                    this.ihiConnectionErrorsView.Height = this.ihiConnectionErrorsTab.Height;
                    this.ihiConnectionErrorsView.TabStop = true;
                    this.ihiConnectionErrorsView.TabIndex = 3;
                }

                // Setup the PCEHR Error Data Grid View
                if (pcehrErrorsTabShow)
                {
                    this.pcehrErrorsView.AllowUserToAddRows = false;
                    this.pcehrErrorsView.AllowUserToDeleteRows = false;
                    this.pcehrErrorsView.AllowUserToResizeColumns = true;
                    this.pcehrErrorsView.AllowUserToResizeRows = false;
                    this.pcehrErrorsView.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left)
                    | System.Windows.Forms.AnchorStyles.Right | System.Windows.Forms.AnchorStyles.Bottom)));
                    this.pcehrErrorsView.AutoSizeColumnsMode = System.Windows.Forms.DataGridViewAutoSizeColumnsMode.Fill;
                    this.pcehrErrorsView.RowHeadersVisible = false;
                    this.pcehrErrorsView.ColumnHeadersHeightSizeMode = System.Windows.Forms.DataGridViewColumnHeadersHeightSizeMode.AutoSize;
                    this.pcehrErrorsView.MultiSelect = true;
                    this.pcehrErrorsView.Name = "PCEHRErrorsView";
                    this.pcehrErrorsView.ReadOnly = true;
                    this.pcehrErrorsView.RowHeadersWidthSizeMode = System.Windows.Forms.DataGridViewRowHeadersWidthSizeMode.AutoSizeToDisplayedHeaders;
                    this.pcehrErrorsView.SelectionMode = System.Windows.Forms.DataGridViewSelectionMode.FullRowSelect;
                    this.pcehrErrorsView.Size = new System.Drawing.Size(557, 90);
                    this.pcehrErrorsView.Width = DATAVIEW_FIXED_WIDTH;
                    this.pcehrErrorsView.Height = this.pcehrErrorsTab.Height;
                    this.pcehrErrorsView.ScrollBars = ScrollBars.Both;
                    this.pcehrErrorsView.TabStop = true;
                    this.pcehrErrorsView.TabIndex = 2;
                }

                // Setup the PCEHR Info Data Grid View
                if (pcehrInfoTabShow)
                {
                    this.pcehrInfoView.AllowUserToAddRows = false;
                    this.pcehrInfoView.AllowUserToDeleteRows = false;
                    this.pcehrInfoView.AllowUserToResizeColumns = true;
                    this.pcehrInfoView.AllowUserToResizeRows = false;
                    this.pcehrInfoView.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left)
                    | System.Windows.Forms.AnchorStyles.Right | System.Windows.Forms.AnchorStyles.Bottom)));
                    this.pcehrInfoView.AutoSizeColumnsMode = System.Windows.Forms.DataGridViewAutoSizeColumnsMode.Fill;
                    this.pcehrInfoView.RowHeadersVisible = false;
                    this.pcehrInfoView.ColumnHeadersHeightSizeMode = System.Windows.Forms.DataGridViewColumnHeadersHeightSizeMode.AutoSize;
                    this.pcehrInfoView.MultiSelect = true;
                    this.pcehrInfoView.Name = "PCEHRInfoView";
                    this.pcehrInfoView.ReadOnly = true;
                    this.pcehrInfoView.RowHeadersWidthSizeMode = System.Windows.Forms.DataGridViewRowHeadersWidthSizeMode.AutoSizeToDisplayedHeaders;
                    this.pcehrInfoView.SelectionMode = System.Windows.Forms.DataGridViewSelectionMode.FullRowSelect;
                    this.pcehrInfoView.Size = new System.Drawing.Size(557, 90);
                    this.pcehrInfoView.Width = DATAVIEW_FIXED_WIDTH;
                    this.pcehrInfoView.Height = this.pcehrInfoTab.Height;
                    this.pcehrInfoView.ScrollBars = ScrollBars.Both;
                    this.pcehrInfoView.TabStop = true;
                    this.pcehrInfoView.TabIndex = 2;
                }


                // Setup the Background Processor Data Grid View
                if (backgroundProcessorTabShow)
                {
                    this.backgroundProcessorView.AllowUserToAddRows = false;
                    this.backgroundProcessorView.AllowUserToDeleteRows = false;
                    this.backgroundProcessorView.AllowUserToResizeColumns = true;
                    this.backgroundProcessorView.AllowUserToResizeRows = false;
                    this.backgroundProcessorView.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left)
                    | System.Windows.Forms.AnchorStyles.Right | System.Windows.Forms.AnchorStyles.Bottom)));
                    this.backgroundProcessorView.AutoSizeColumnsMode = System.Windows.Forms.DataGridViewAutoSizeColumnsMode.Fill;
                    this.backgroundProcessorView.RowHeadersVisible = false;
                    this.backgroundProcessorView.ColumnHeadersHeightSizeMode = System.Windows.Forms.DataGridViewColumnHeadersHeightSizeMode.AutoSize;
                    this.backgroundProcessorView.MultiSelect = true;
                    this.backgroundProcessorView.Name = "BackgroundProcessorView";
                    this.backgroundProcessorView.ReadOnly = true;
                    this.backgroundProcessorView.RowHeadersWidthSizeMode = System.Windows.Forms.DataGridViewRowHeadersWidthSizeMode.AutoSizeToDisplayedHeaders;
                    this.backgroundProcessorView.SelectionMode = System.Windows.Forms.DataGridViewSelectionMode.FullRowSelect;
                    this.backgroundProcessorView.Size = new System.Drawing.Size(557, 90);
                    this.backgroundProcessorView.Width = DATAVIEW_FIXED_WIDTH;
                    this.backgroundProcessorView.Height = this.backgroundProcessorTab.Height;
                    this.backgroundProcessorView.ScrollBars = ScrollBars.Both;
                    this.backgroundProcessorView.TabStop = true;
                    this.backgroundProcessorView.TabIndex = 2;
                }


                // Setup the msmq Info Data Grid View
                if (msmqInfoTabShow)
                {
                    this.msmqInfoView.AllowUserToAddRows = false;
                    this.msmqInfoView.AllowUserToDeleteRows = false;
                    this.msmqInfoView.AllowUserToResizeColumns = true;
                    this.msmqInfoView.AllowUserToResizeRows = false;
                    this.msmqInfoView.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left)
                    | System.Windows.Forms.AnchorStyles.Right | System.Windows.Forms.AnchorStyles.Bottom)));
                    this.msmqInfoView.AutoSizeColumnsMode = System.Windows.Forms.DataGridViewAutoSizeColumnsMode.Fill;
                    this.msmqInfoView.RowHeadersVisible = false;
                    this.msmqInfoView.ColumnHeadersHeightSizeMode = System.Windows.Forms.DataGridViewColumnHeadersHeightSizeMode.AutoSize;
                    this.msmqInfoView.MultiSelect = true;
                    this.msmqInfoView.Name = "MsmqInfoView";
                    this.msmqInfoView.ReadOnly = true;
                    this.msmqInfoView.RowHeadersWidthSizeMode = System.Windows.Forms.DataGridViewRowHeadersWidthSizeMode.AutoSizeToDisplayedHeaders;
                    this.msmqInfoView.SelectionMode = System.Windows.Forms.DataGridViewSelectionMode.FullRowSelect;
                    this.msmqInfoView.Size = new System.Drawing.Size(557, 90);
                    this.msmqInfoView.Width = DATAVIEW_FIXED_WIDTH;
                    this.msmqInfoView.Height = this.msmqInfoTab.Height;
                    this.msmqInfoView.ScrollBars = ScrollBars.Both;
                    this.msmqInfoView.TabStop = true;
                    this.msmqInfoView.TabIndex = 2;
                }

                // Setup the PUMA Errors Data Grid View
                if (pumaErrorsTabShow)
                {
                    this.pumaErrorView.AllowUserToAddRows = false;
                    this.pumaErrorView.AllowUserToDeleteRows = false;
                    this.pumaErrorView.AllowUserToResizeColumns = true;
                    this.pumaErrorView.AllowUserToResizeRows = false;
                    this.pumaErrorView.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left)
                    | System.Windows.Forms.AnchorStyles.Right | System.Windows.Forms.AnchorStyles.Bottom)));
                    this.pumaErrorView.AutoSizeColumnsMode = System.Windows.Forms.DataGridViewAutoSizeColumnsMode.Fill;
                    this.pumaErrorView.RowHeadersVisible = false;
                    this.pumaErrorView.ColumnHeadersHeightSizeMode = System.Windows.Forms.DataGridViewColumnHeadersHeightSizeMode.AutoSize;
                    this.pumaErrorView.MultiSelect = true;
                    this.pumaErrorView.Name = "PumaErrorView";
                    this.pumaErrorView.ReadOnly = true;
                    this.pumaErrorView.RowHeadersWidthSizeMode = System.Windows.Forms.DataGridViewRowHeadersWidthSizeMode.AutoSizeToDisplayedHeaders;
                    this.pumaErrorView.SelectionMode = System.Windows.Forms.DataGridViewSelectionMode.FullRowSelect;
                    this.pumaErrorView.Size = new System.Drawing.Size(557, 90);
                    this.pumaErrorView.Width = DATAVIEW_FIXED_WIDTH;
                    this.pumaErrorView.Height = this.pumaErrorsTab.Height;
                    this.pumaErrorView.ScrollBars = ScrollBars.Both;
                    this.pumaErrorView.TabStop = true;
                    this.pumaErrorView.TabIndex = 2;
                }


                // Setup the PCEHR Upload Errors Data Grid View
                if (pcehrUploadErrorsTabShow)
                {
                    this.pcehrUploadErrorView.AllowUserToAddRows = false;
                    this.pcehrUploadErrorView.AllowUserToDeleteRows = false;
                    this.pcehrUploadErrorView.AllowUserToResizeColumns = true;
                    this.pcehrUploadErrorView.AllowUserToResizeRows = false;
                    this.pcehrUploadErrorView.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left)
                    | System.Windows.Forms.AnchorStyles.Right | System.Windows.Forms.AnchorStyles.Bottom)));
                    this.pcehrUploadErrorView.AutoSizeColumnsMode = System.Windows.Forms.DataGridViewAutoSizeColumnsMode.Fill;
                    this.pcehrUploadErrorView.RowHeadersVisible = false;
                    this.pcehrUploadErrorView.ColumnHeadersHeightSizeMode = System.Windows.Forms.DataGridViewColumnHeadersHeightSizeMode.AutoSize;
                    this.pcehrUploadErrorView.MultiSelect = true;
                    this.pcehrUploadErrorView.Name = "PcehrUploadErrorView";
                    this.pcehrUploadErrorView.ReadOnly = true;
                    this.pcehrUploadErrorView.RowHeadersWidthSizeMode = System.Windows.Forms.DataGridViewRowHeadersWidthSizeMode.AutoSizeToDisplayedHeaders;
                    this.pcehrUploadErrorView.SelectionMode = System.Windows.Forms.DataGridViewSelectionMode.FullRowSelect;
                    this.pcehrUploadErrorView.Size = new System.Drawing.Size(557, 90);
                    this.pcehrUploadErrorView.Width = DATAVIEW_FIXED_WIDTH;
                    this.pcehrUploadErrorView.Height = this.pcehrUploadErrorsTab.Height;
                    this.pcehrUploadErrorView.ScrollBars = ScrollBars.Both;
                    this.pcehrUploadErrorView.TabStop = true;
                    this.pcehrUploadErrorView.TabIndex = 2;
                    this.pcehrUploadErrorView.DoubleClick += new System.EventHandler(this.pcehrUploadErrors_DoubleClick);
                }

                // Setup the PCEHR Uploaded Document Data Grid View
                if (pcehrUploadedDocumentTabShow)
                {
                    this.pcehrUploadedDocumentsView.AllowUserToAddRows = false;
                    this.pcehrUploadedDocumentsView.AllowUserToDeleteRows = false;
                    this.pcehrUploadedDocumentsView.AllowUserToResizeColumns = true;
                    this.pcehrUploadedDocumentsView.AllowUserToResizeRows = false;
                    this.pcehrUploadedDocumentsView.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left)
                    | System.Windows.Forms.AnchorStyles.Right | System.Windows.Forms.AnchorStyles.Bottom)));
                    this.pcehrUploadedDocumentsView.AutoSizeColumnsMode = System.Windows.Forms.DataGridViewAutoSizeColumnsMode.Fill;
                    this.pcehrUploadedDocumentsView.RowHeadersVisible = false;
                    this.pcehrUploadedDocumentsView.ColumnHeadersHeightSizeMode = System.Windows.Forms.DataGridViewColumnHeadersHeightSizeMode.AutoSize;
                    this.pcehrUploadedDocumentsView.MultiSelect = true;
                    this.pcehrUploadedDocumentsView.Name = "PcehrUploadedDocumentsView";
                    this.pcehrUploadedDocumentsView.ReadOnly = true;
                    this.pcehrUploadedDocumentsView.RowHeadersWidthSizeMode = System.Windows.Forms.DataGridViewRowHeadersWidthSizeMode.AutoSizeToDisplayedHeaders;
                    this.pcehrUploadedDocumentsView.SelectionMode = System.Windows.Forms.DataGridViewSelectionMode.FullRowSelect;
                    this.pcehrUploadedDocumentsView.Size = new System.Drawing.Size(557, 90);
                    this.pcehrUploadedDocumentsView.Width = DATAVIEW_FIXED_WIDTH;
                    this.pcehrUploadedDocumentsView.Height = this.pcehrUploadedDocumentTab.Height;
                    this.pcehrUploadedDocumentsView.ScrollBars = ScrollBars.Both;
                    this.pcehrUploadedDocumentsView.TabStop = true;
                    this.pcehrUploadedDocumentsView.TabIndex = 2;
                }

                #endregion

                hideErrors();
            }
            catch (SqlException err)
            {
                MessageBox.Show(err.Message);
                this.Close();
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }

            notifyIcon.Visible = true;
            toolStripStatusLabelUpdate.Text = "HIPS Monitor initialising. Please wait...";
            this.ShowInTaskbar = false;
            //this.Hide();

            //// Populate the data source with initial data.
            mainGridSource.Add(new InfoMessages("IHI Lookup percentage connection failure in the last " + hipsInfo.IhiConnectionTime + " minutes", hipsInfo.IhiConnectionFailurePercentage.ToString("P2", CultureInfo.InvariantCulture)));
            mainGridSource.Add(new InfoMessages("Average IHI Lookup time in the last " + hipsInfo.HoursForRollingAverage + " hours", hipsInfo.CurrentAverage.ToString() + " (s)"));

            mainGridSource.Add(new InfoMessages("PCEHR Lookup percentage connection failure in the last " + hipsInfo.IhiConnectionTime + " minutes", hipsInfo.PcehrConnectionFailurePercentage.ToString("P2", CultureInfo.InvariantCulture)));
            mainGridSource.Add(new InfoMessages("Average PCEHR Lookup time in the last " + hipsInfo.HoursForRollingAverage + " hours", hipsInfo.CurrentPcehrAverage.ToString() + " (s)"));

            mainGridSource.Add(new InfoMessages("PAS messages in the last " + hipsInfo.PasRefreshTime + " minutes", hipsInfo.PasMessageCount.ToString()));
            mainGridSource.Add(new InfoMessages("HIPS errors in the last " + hipsInfo.PasFailureHours + " hours", hipsInfo.PasErrorMessageCount.ToString()));

            mainGridSource.Add(new InfoMessages("PCEHR items in a pending state", hipsInfo.PcehrPendingCount.ToString()));
            mainGridSource.Add(new InfoMessages("PCEHR failed items in the last " + hipsInfo.PcehrFailedDays.ToString() + " days", hipsInfo.PcehrFailedCount.ToString()));

            if (hipsInfo.ConsentTimeChecked == null)
            {
                mainGridSource.Add(new InfoMessages("Last consent service request has not yet been run.", hipsInfo.ConsentPatientsChecked.ToString()));
            }
            else
            {
                mainGridSource.Add(new InfoMessages("Last consent service request at " + hipsInfo.ConsentTimeChecked.ToString(), hipsInfo.ConsentPatientsChecked.ToString()));
            }
            



            #region Main Grid Initialisation

            //// Initialize the DataGridView.
            mainGridView.AutoGenerateColumns = false;
            mainGridView.DataSource = mainGridSource;
            this.mainGridView.Refresh();

            //// Initialize and add a text box column.
            DataGridViewColumn column1 = new DataGridViewTextBoxColumn();
            column1.DataPropertyName = "Message";
            column1.Name = "Message";
            column1.Width = 700;
            mainGridView.Columns.Add(column1);

            DataGridViewColumn column2 = new DataGridViewTextBoxColumn();
            column2.AutoSizeMode = DataGridViewAutoSizeColumnMode.None;
            column2.DataPropertyName = "Result";
            column2.Name = "Result";
            mainGridView.Columns.Add(column2);

            DataGridViewColumn column = new DataGridViewImageColumn();
            column.AutoSizeMode = DataGridViewAutoSizeColumnMode.None;
            column.DataPropertyName = "Image";
            column.Name = "Image";
            mainGridView.Columns.Add(column);

            this.mainGridView.AllowUserToAddRows = false;
            this.mainGridView.AllowUserToDeleteRows = false;
            this.mainGridView.AllowUserToResizeColumns = false;
            this.mainGridView.AllowUserToResizeRows = false;
            this.mainGridView.RowHeadersVisible = false;
            this.mainGridView.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left)
            | System.Windows.Forms.AnchorStyles.Right)));
            this.mainGridView.AutoSizeColumnsMode = System.Windows.Forms.DataGridViewAutoSizeColumnsMode.Fill;
            this.mainGridView.ColumnHeadersHeightSizeMode = System.Windows.Forms.DataGridViewColumnHeadersHeightSizeMode.AutoSize;
            this.mainGridView.Location = new System.Drawing.Point(3, 3);
            this.mainGridView.MultiSelect = false;
            this.mainGridView.Name = "mainGridView";
            this.mainGridView.ReadOnly = true;
            this.mainGridView.RowHeadersWidthSizeMode = System.Windows.Forms.DataGridViewRowHeadersWidthSizeMode.AutoSizeToDisplayedHeaders;
            this.mainGridView.SelectionMode = System.Windows.Forms.DataGridViewSelectionMode.FullRowSelect;
            this.mainGridView.Size = new System.Drawing.Size(DATAVIEW_FIXED_WIDTH+9, 222);


            //displayAllErrorsLabel.Text = "* Displays all Errors in last " + hipsInfo.PcehrFailedDays.ToString() + ((hipsInfo.PcehrFailedDays > 1) ? " days" : " day"); 


            //// Initialize the form. 
            this.Controls.Add(mainGridView);

            #endregion

            this.Refresh();
        }

        private void updatePage()
        {
            this.pasMessageCountTextBox.Text = hipsInfo.TotalPasMessageCount.ToString();
            this.patientCountTextBox.Text = hipsInfo.TotalPatients.ToString();
            this.cdaDocumentUploadTextBox.Text = hipsInfo.CdaDocumentsUploaded.ToString();

            this.ihiCountTextBox.Text = hipsInfo.TotalIhisFound.ToString();
            this.pcehrAdvertisedTextBox.Text = hipsInfo.PcehrAdvertised.ToString();
            this.ihiPercentage.Text = hipsInfo.IhiPercentage.ToString("0,0.00");
            this.pcehrPercentage.Text = hipsInfo.PcehrPercentage.ToString("0,0.00");

        }
      
        private void LookupAverage()
        {
            decimal ave = 0;
            
            InfoMessages info = (InfoMessages)mainGridView.Rows[1].DataBoundItem;
            try
            {
                ave = hipsInfo.CurrentAverage;
                if (ave > 20)
                {
                    if (!snoozing)
                    {
                        redError = true;
                        info.Image = Properties.Resources.Redicon;
                        info.Image.Tag = DashboardForm.RED;
                        notifyIcon.BalloonTipText = "Average IHI Lookup time has increased. Lookups are taking longer than 20s.";
                        AddNotifyText("IHI service maybe down");
                    }
                }
                else if (ave > 10)
                {
                    if (!snoozing) 
                    {
                        if (!redError)
                        {
                            orangeWarning = true;
                        }
                        info.Image = Properties.Resources.Goldicon;
                        info.Image.Tag = DashboardForm.ORANGE;
                        notifyIcon.BalloonTipText = "Average IHI Lookup time has increased.";
                        AddNotifyText("IHI service may be going down.");
                    }
                }
                else
                {
                    if (!redError && !orangeWarning)
                    {
                        greenFlag = true;
                        //notifyIcon.Icon = HipsMonitoring.Properties.Resources.green;
                    }
                    info.Image = Properties.Resources.ActivityMonitoricon;
                    info.Image.Tag = DashboardForm.GREEN;   

                }
            }
            catch (Exception e)
            {
                MessageBox.Show(e.Message);
            }
            info.Result = ave.ToString() + " (s)";

        }

        private void PcehrLookupAverage()
        {
            decimal ave = 0;

            InfoMessages info = (InfoMessages)mainGridView.Rows[3].DataBoundItem;
            try
            {
                ave = hipsInfo.CurrentPcehrAverage;
                if (ave > 20)
                {
                    if (!snoozing)
                    {
                        redError = true;
                        info.Image = Properties.Resources.Redicon;
                        info.Image.Tag = DashboardForm.RED;
                        notifyIcon.BalloonTipText = "Average PCEHR Lookup time has increased. Lookups are taking longer than 20s.";
                        AddNotifyText("PCEHR service maybe down");
                    }
                }
                else if (ave > 10)
                {
                    if (!snoozing)
                    {
                        if (!redError)
                        {
                            orangeWarning = true;
                        }
                        info.Image = Properties.Resources.Goldicon;
                        info.Image.Tag = DashboardForm.ORANGE;
                        notifyIcon.BalloonTipText = "Average PCEHR Lookup time has increased.";
                        AddNotifyText("PCEHR service may be going down.");
                    }
                }
                else
                {
                    if (!redError && !orangeWarning)
                    {
                        greenFlag = true;
                        //notifyIcon.Icon = HipsMonitoring.Properties.Resources.green;
                    }
                    info.Image = Properties.Resources.ActivityMonitoricon;
                    info.Image.Tag = DashboardForm.GREEN;

                }
            }
            catch (Exception e)
            {
                MessageBox.Show(e.Message);
            }
            info.Result = ave.ToString() + " (s)";

        }


        private void PasCount()
        {
            int count = 0;
            count = hipsInfo.PasMessageCount;
            InfoMessages info = (InfoMessages)mainGridView.Rows[4].DataBoundItem;

            System.Diagnostics.Debug.WriteLine(count.ToString() + ":" + lastPasMessageCount.ToString() + ":" + alertAcknowledgedPasCount.ToString());
            //compare this value to the last time it was looked up, if different and it has not been alertAcknowledgedPasCount then allow an alert (again), 
            //if it is the same and has been alertAcknowledgedPasCount we can suppress it until it changes again
            if (count != lastPasMessageCount || !alertAcknowledgedPasCount)
            {
                if (count == 0)
                {
                    if (!snoozing)
                    {
                        redError = true;
                        info.Image = Properties.Resources.Redicon;
                        info.Image.Tag = DashboardForm.RED;
                        alertAcknowledgedPasCount = false;
                        this.ShowNotification("PAS Message alert", "No PAS messages received in the last " + hipsInfo.PasRefreshTime + " minutes");
                    }
                }
                else
                {
                    if (!redError && !orangeWarning)
                    {
                        greenFlag = true;
                        //notifyIcon.Icon = HipsMonitoring.Properties.Resources.green;
                    }
                    info.Image = Properties.Resources.ActivityMonitoricon;
                    info.Image.Tag = DashboardForm.GREEN;

                }
            }

            string result;
            if (count != lastPasMessageCount)
            {
                result = count.ToString() + " *";
            }
            else
            {
                result = count.ToString();
            }

            //update
            info.Result = result;
            lastPasMessageCount = count;
            this.Refresh();
        }

        private void IhiAlert()
        {
            decimal count = 0;
            InfoMessages info = (InfoMessages)mainGridView.Rows[0].DataBoundItem;
            try
            {
                count = hipsInfo.IhiConnectionFailurePercentage;
                System.Diagnostics.Debug.WriteLine(count.ToString() + ":" + lastIhiConnectionFailurePercentage.ToString() + ":" + alertAcknowledgedIhiConnFailure.ToString());
                //compare this value to the last time it was looked up, if different and it has not been alertAcknowledgedIhiConnFailure then allow an alert (again), 
                //if it is the same and has been alertAcknowledgedIhiConnFailure we can suppress it until it changes again
                if (count != lastIhiConnectionFailurePercentage || !alertAcknowledgedIhiConnFailure)
                {
                    System.Diagnostics.Debug.WriteLine("Alert Testing");
                    if (count >= 50)
                    {
                        redError = true;
                        
                        //notifyIcon.Icon = HipsMonitoring.Properties.Resources.ErrorIcon;
                        notifyIcon.BalloonTipText = count.ToString() + "% of IHI lookups have failed. The IHI server may be down";
                        //stop showing messages if snoozing
                        if (!snoozing && !shown)
                        {
                            showSnooze = true;
                            snoozeButton.Visible = true;
                            alertAcknowledgedIhiConnFailure = false;
                            notifyIcon.ShowBalloonTip(2000, "IHI Lookup failures", notifyIcon.BalloonTipText, ToolTipIcon.Error);
                        }
                        AddNotifyText("IHI Service connection failure above 50%. Click for details.");
                        info.Image = Properties.Resources.Redicon;
                        info.Image.Tag = DashboardForm.RED;


                        //stop showing messages if snoozing
                        if (!snoozing)
                        {
                            showSnooze = true;
                            snoozeButton.Visible = true;

                            this.Show();
                            this.Activate();
                            this.BringToFront();
                        }
                    }
                    else if (count >= 20)
                    {
                        //don't downgrade if red error status
                        if (!redError)
                        {
                            orangeWarning = true;
                            //notifyIcon.Icon = HipsMonitoring.Properties.Resources.orange;
                            notifyIcon.BalloonTipText = count.ToString() + "% of IHI lookups have failed";
                            AddNotifyText("IHI server may be down. Click for details.");

                            //stop showing messages if snoozing
                            if (!snoozing && !shown)
                            {
                                showSnooze = true;
                                snoozeButton.Visible = true;
                                alertAcknowledgedIhiConnFailure = false;
                                notifyIcon.ShowBalloonTip(2000, "IHI Lookup failures", notifyIcon.BalloonTipText, ToolTipIcon.Warning);
                            }
                        }

                        info.Image = Properties.Resources.Goldicon;
                        info.Image.Tag = DashboardForm.ORANGE;
                    }
                    else
                    {
                         //don't downgrade if red error or orange warning status
                        if (!redError && !orangeWarning)
                        {
                            greenFlag = true;
                            //notifyIcon.Icon = HipsMonitoring.Properties.Resources.green;
                            AddNotifyText("IHI service in good health");
                        }

                        info.Image = Properties.Resources.ActivityMonitoricon;
                        info.Image.Tag = DashboardForm.GREEN;
                    }
                }
            }
            catch (SqlException err)
            {
                throw err;
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }

            string result;
            if (count != lastIhiConnectionFailurePercentage)
            {
                result = count.ToString() + " *";
            }
            else
            {
                result = count.ToString();
            }

            //update
            info.Result = result;
            lastIhiConnectionFailurePercentage = count;
            this.Refresh();
           
        }

        private void PcehrAlert()
        {
            decimal count = 0;
            InfoMessages info = (InfoMessages)mainGridView.Rows[2].DataBoundItem;
            try
            {
                count = hipsInfo.PcehrConnectionFailurePercentage;
                System.Diagnostics.Debug.WriteLine(count.ToString() + ":" + lastPcehrConnectionFailurePercentage.ToString() + ":" + alertAcknowledgedPcehrConnFailure.ToString());
                //compare this value to the last time it was looked up, if different and it has not been alertAcknowledgedIhiConnFailure then allow an alert (again), 
                //if it is the same and has been alertAcknowledgedIhiConnFailure we can suppress it until it changes again
                if (count != lastPcehrConnectionFailurePercentage || !alertAcknowledgedPcehrConnFailure)
                {
                    System.Diagnostics.Debug.WriteLine("Alert Testing");
                    if (count >= 50)
                    {
                        redError = true;

                        //notifyIcon.Icon = HipsMonitoring.Properties.Resources.ErrorIcon;
                        notifyIcon.BalloonTipText = count.ToString() + "% of PCEHR lookups have failed. The PCEHR server may be down";
                        //stop showing messages if snoozing
                        if (!snoozing && !shown)
                        {
                            showSnooze = true;
                            snoozeButton.Visible = true;
                            alertAcknowledgedPcehrConnFailure = false;
                            notifyIcon.ShowBalloonTip(2000, "PCEHR Lookup failures", notifyIcon.BalloonTipText, ToolTipIcon.Error);
                        }
                        AddNotifyText("PCEHR Service connection failure above 50%. Click for details.");
                        info.Image = Properties.Resources.Redicon;
                        info.Image.Tag = DashboardForm.RED;

                        //stop showing messages if snoozing
                        if (!snoozing)
                        {
                            showSnooze = true;
                            snoozeButton.Visible = true;

                            this.Show();
                            this.Activate();
                            this.BringToFront();
                        }
                    }
                    else if (count >= 20)
                    {
                        //don't downgrade if red error status
                        if (!redError)
                        {
                            orangeWarning = true;
                            //notifyIcon.Icon = HipsMonitoring.Properties.Resources.orange;
                            notifyIcon.BalloonTipText = count.ToString() + "% of PCEHR lookups have failed";
                            AddNotifyText("PCEHR server may be down. Click for details.");

                            //stop showing messages if snoozing
                            if (!snoozing && !shown)
                            {
                                showSnooze = true;
                                snoozeButton.Visible = true;
                                alertAcknowledgedPcehrConnFailure = false;
                                notifyIcon.ShowBalloonTip(2000, "PCEHR Lookup failures", notifyIcon.BalloonTipText, ToolTipIcon.Warning);
                            }
                        }

                        info.Image = Properties.Resources.Goldicon;
                        info.Image.Tag = DashboardForm.ORANGE;
                    }
                    else
                    {
                         //don't downgrade if red error or orange warning status
                        if (!redError && !orangeWarning)
                        {
                            greenFlag = true;
                            //notifyIcon.Icon = HipsMonitoring.Properties.Resources.green;
                            AddNotifyText("PCEHR service in good health");
                        }

                        info.Image = Properties.Resources.ActivityMonitoricon;
                        info.Image.Tag = DashboardForm.GREEN;
                    }
                }
            }
            catch (SqlException err)
            {
                throw err;
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }

            string result;
            if (count != lastPcehrConnectionFailurePercentage)
            {
                result = count.ToString() + " *";
            }
            else
            {
                result = count.ToString();
            }

            //update
            info.Result = result;
            lastPcehrConnectionFailurePercentage = count;
            this.Refresh();

        }

        private void PasErrorMessageCount()
        {
            int count = 0;
            InfoMessages info = (InfoMessages)mainGridView.Rows[5].DataBoundItem;
            try
            {
                count = hipsInfo.PasErrorMessageCount;
                System.Diagnostics.Debug.WriteLine(count.ToString() + ":" + lastPasErrorMessageCount.ToString() + ":" + alertAcknowledgedPasError.ToString());
                //compare this value to the last time it was looked up, if different and it has not been alertAcknowledgedPasError then allow an alert (again), 
                //if it is the same and has been alertAcknowledgedPasError we can suppress it until it changes again
                if (count != lastPasErrorMessageCount || !alertAcknowledgedPasError)
                {
                    System.Diagnostics.Debug.WriteLine("Alert Testing");
                    if (count >= 5)
                    {
                        redError = true;

                        //notifyIcon.Icon = HipsMonitoring.Properties.Resources.ErrorIcon;

                        notifyIcon.BalloonTipText = count.ToString() + " PAS Message(s) have failed";
                        //stop showing messages if snoozing has already been shown
                        if (!snoozing && !shown)
                        {
                            showSnooze = true;
                            snoozeButton.Visible = true;
                            alertAcknowledgedPasError = false;
                            notifyIcon.ShowBalloonTip(2000, "PAS Message Failure", notifyIcon.BalloonTipText, ToolTipIcon.Error);
                        }
                        AddNotifyText(count.ToString() + " PAS Message(s) have failed. Click for details.");
                        info.Image = Properties.Resources.Redicon;
                        info.Image.Tag = DashboardForm.RED;

                        //stop showing messages if snoozing
                        if (!snoozing)
                        {
                            showSnooze = true;
                            snoozeButton.Visible = true;

                            this.Show();
                            this.Activate();
                            this.BringToFront();
                        }

                    }
                    else if (count >= 1)
                    {
                        //don't downgrade if red error status
                        if (!redError)
                        {
                            orangeWarning = true;
                            //notifyIcon.Icon = HipsMonitoring.Properties.Resources.orange;

                            notifyIcon.BalloonTipText = count.ToString() + " PAS Message(s) have failed";
                            notifyIcon.BalloonTipIcon = ToolTipIcon.Error;
                            AddNotifyText(count.ToString() + " PAS Message(s) have failed. Click for details.");

                            //stop showing messages if snoozing
                            if (!snoozing && !shown)
                            {
                                showSnooze = true;
                                snoozeButton.Visible = true;
                                alertAcknowledgedPasError = false;
                                notifyIcon.ShowBalloonTip(2000, "PAS Message Failure", notifyIcon.BalloonTipText, ToolTipIcon.Error);
                            }
                        }

                        info.Image = Properties.Resources.Goldicon;
                        info.Image.Tag = DashboardForm.ORANGE;
                    }
                    else
                    {
                        //don't downgrade if red error or orange warning status
                        if (!redError && !orangeWarning)
                        {
                            greenFlag = true;
                            //notifyIcon.Icon = HipsMonitoring.Properties.Resources.green;    
                            AddNotifyText("PAS Messaging is in good health");
                        }

                        info.Image = Properties.Resources.ActivityMonitoricon;
                        info.Image.Tag = DashboardForm.GREEN;

                    }
                }
            }
            catch (SqlException err)
            {
                throw err;
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }

            string result;
            if (count != lastPasErrorMessageCount)
            {
                result = count.ToString() + " *";
            }
            else
            { 
               result = count.ToString(); 
            }

            //update
            info.Result = result;
            lastPasErrorMessageCount = count;
            this.Refresh();
        }

        private void PcehrFailedUpdate()
        {
            int count = 0;
            count = hipsInfo.PcehrFailedCount;
            InfoMessages info = (InfoMessages)mainGridView.Rows[7].DataBoundItem;

            System.Diagnostics.Debug.WriteLine(count.ToString() + ":" + lastPcehrFailedCount.ToString() + ":" + alertAcknowledgedPcehrQueueFailure.ToString());
            //compare this value to the last time it was looked up, if different and it has not been alertAcknowledgedPcehrQueueFailure then allow an alert (again), 
            //if it is the same and has been alertAcknowledgedPcehrQueueFailure we can suppress it until it changes again
            if (count != lastPcehrFailedCount || !alertAcknowledgedPcehrQueueFailure)
             {
                 if (hipsInfo.PcehrFailedCount > 0)
                 {
                     if (!snoozing) 
                     {
                         redError = true;
                         info.Image = Properties.Resources.Redicon;
                         info.Image.Tag = DashboardForm.RED;
                         alertAcknowledgedPcehrQueueFailure = false;
                         this.ShowNotification("PCEHR Queue Failure", hipsInfo.PcehrFailedCount + " PCEHR requests have failed.");
                     }
                 }
                 else
                 {
                     if (!redError && !orangeWarning)
                     {
                         greenFlag = true;
                         //notifyIcon.Icon = HipsMonitoring.Properties.Resources.green;
                     }
                     info.Image = Properties.Resources.ActivityMonitoricon;
                     info.Image.Tag = DashboardForm.GREEN;

                 }
             }

             string result;
             if (count != lastPcehrFailedCount)
             {
                 result = count.ToString() + " *";
             }
             else
             {
                 result = count.ToString();
             }

             //update
             info.Result = result;
             lastPcehrFailedCount = count;
             this.Refresh();
        }


        private void PcehrPendingUpdate()
        {
            int count = 0;
            count = hipsInfo.PcehrPendingCount;
            InfoMessages info = (InfoMessages)mainGridView.Rows[6].DataBoundItem;

            System.Diagnostics.Debug.WriteLine(count.ToString() + ":" + lastPcehrPendingCount.ToString() + ":" + alertAcknowledgedPcehrQueuePending.ToString());
            //compare this value to the last time it was looked up, if different and it has not been alertAcknowledgedPcehrQueuePending then allow an alert (again), 
            //if it is the same and has been alertAcknowledgedPcehrQueuePending we can suppress it until it changes again
            if (count != lastPcehrPendingCount || !alertAcknowledgedPcehrQueuePending)
            {

                if (hipsInfo.PcehrOldestPendingMinutes > 20)
                {
                    if (!snoozing)
                    {
                        redError = true;
                        info.Image = Properties.Resources.Redicon;
                        info.Image.Tag = DashboardForm.RED;
                        alertAcknowledgedPcehrQueuePending = false;
                        this.ShowNotification("PCEHR Queue warning", hipsInfo.PcehrPendingCount + " PCEHR requests are pending.");
                    }
                }
                else if (hipsInfo.PcehrOldestPendingMinutes > 10)
                {
                    if (!redError)
                    {
                        orangeWarning = true;
                        //notifyIcon.Icon = HipsMonitoring.Properties.Resources.orange;
                    }
                    info.Image = Properties.Resources.Goldicon;
                    info.Image.Tag = DashboardForm.ORANGE;
                }
                else
                {
                    if (!redError && !orangeWarning)
                    {
                        greenFlag = true;
                        //notifyIcon.Icon = HipsMonitoring.Properties.Resources.green;
                    }
                    info.Image = Properties.Resources.ActivityMonitoricon;
                    info.Image.Tag = DashboardForm.GREEN;
                }

            }
            string result;
            if (count != lastPcehrPendingCount)
            {
                result = count.ToString() + " *";
            }
            else
            {
                result = count.ToString();
            }

            //update
            info.Result = result;
            lastPcehrPendingCount = count;
            this.Refresh();
        }

        private void ConsentServiceUpdate()
        {
            int count = 0;
            count = hipsInfo.ConsentPatientsChecked;
            InfoMessages info = (InfoMessages)mainGridView.Rows[8].DataBoundItem;

            System.Diagnostics.Debug.WriteLine(count.ToString() + ":" + lastConsentPatientsChecked.ToString() + ":" + alertAcknowledgedConsentServiceFailure.ToString());
            //compare this value to the last time it was looked up, if different and it has not been alertAcknowledgedConsentServiceFailure then allow an alert (again), 
            //if it is the same and has been alertAcknowledgedConsentServiceFailure we can suppress it until it changes again
            if (hipsInfo.ConsentTimeChecked < DateTime.Now.AddHours(-2))
            {
                if (!snoozing)
                {
                    info.Image = Properties.Resources.Redicon;
                    info.Image.Tag = DashboardForm.RED;
                    alertAcknowledgedConsentServiceFailure = false;
                    this.ShowNotification("Consent Service Failure", "Consent Service last used: " + hipsInfo.ConsentTimeChecked.ToString());
                }
            }
            else
            {
                info.Image = Properties.Resources.ActivityMonitoricon;
                info.Image.Tag = DashboardForm.GREEN;
                greenFlag = true;
            }

            string result;
            if (count != lastConsentPatientsChecked)
            {
                result = count.ToString() + " *";
            }
            else
            {
                result = count.ToString();
            }

            //update
            info.Result = result;
            info.Message = "Last consent service request at " + hipsInfo.ConsentTimeChecked.ToString();
            lastConsentPatientsChecked = count;
            this.Refresh();
        }

        private void contextMenuStrip_Opening(object sender, CancelEventArgs e)
        {

        }

        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void DashboardForm_Shown(object sender, EventArgs e)
        {
            this.Hide();
            shown = false;
            alertAcknowledgedPcehrConnFailure = false;
            alertAcknowledgedIhiConnFailure = false;
            alertAcknowledgedPasError = false;
            refreshData();

            pasTimer.Start();
            ihiAlertTimer.Start();
        }

        private void exitToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void notifyIcon1_MouseClick(object sender, MouseEventArgs e)
        {
            this.Show();
            this.Activate();
            this.BringToFront();
        }

        /// <summary>
        /// Handles the Click event of the button1 control.
        /// </summary>
        /// <param name="sender">The source of the event.</param>
        /// <param name="e">The <see cref="EventArgs" /> instance containing the event data.</param>
        private void refresh_Click(object sender, EventArgs e)
        {
            refreshData();
        }

        private void setDataSources()
        {
            if (showErrorsButton.Visible == false)
            {
                if (hipsErrorsTabShow)
                {
                    this.HIPSErrorsSource.DataSource = hipsInfo.GetHIPSErrors();
                    this.HIPSErrorsView.DataSource = this.HIPSErrorsSource;
                    if (this.HIPSErrorsView.RowCount > 0)
                    {
                        try
                        {
                            this.HIPSErrorsView.Columns[this.HIPSErrorsView.ColumnCount - 1].Width = LOG_COLUMN_WIDTH;
                        }
                        catch (Exception e)
                        {
                            //empty invalidation display catch
                        }
                    }
                    this.HIPSErrorsView.Refresh();
                }

                if (ihiConnectionErrorsTabShow)
                {
                    this.ihiConnectionErrorsSource.DataSource = hipsInfo.GetIHIConnectionErrors();
                    this.ihiConnectionErrorsView.DataSource = this.ihiConnectionErrorsSource;
                    if (this.ihiConnectionErrorsView.RowCount > 0)
                    {
                        try
                        {
                            this.ihiConnectionErrorsView.Columns[this.ihiConnectionErrorsView.ColumnCount - 1].Width = LOG_COLUMN_WIDTH;
                        }
                        catch (Exception e)
                        {
                            //empty invalidation display catch
                        }
                    }
                    this.ihiConnectionErrorsView.Refresh();
                }

                if (pcehrErrorsTabShow)
                {
                    this.pcehrErrorsSource.DataSource = hipsInfo.GetPcehrErrors();
                    this.pcehrErrorsView.DataSource = this.pcehrErrorsSource;
                    if (this.pcehrErrorsView.RowCount > 0)
                    {
                        try
                        {
                            this.pcehrErrorsView.Columns[this.pcehrErrorsView.ColumnCount - 1].Width = LOG_COLUMN_WIDTH;
                        }
                        catch (Exception e)
                        {
                            //empty invalidation display catch
                        }
                    }
                    this.pcehrErrorsView.Refresh();
                }

                if (hipsInfoTabShow)
                {
                    this.HIPSInfoSource.DataSource = hipsInfo.GetInfoMessages();
                    this.HIPSInfoView.DataSource = this.HIPSInfoSource;
                    if (this.HIPSInfoView.RowCount > 0)
                    {
                        try
                        {
                            this.HIPSInfoView.Columns[this.HIPSInfoView.ColumnCount - 1].Width = LOG_COLUMN_WIDTH;
                        }
                        catch (Exception e)
                        {
                            //empty invalidation display catch
                        }
                    }
                    this.HIPSInfoView.Refresh();
                }

                if (mergeTabShow)
                {
                    this.MergeInfoSource.DataSource = hipsInfo.GetMergeInfo();
                    this.MergeInfoView.DataSource = this.MergeInfoSource;
                    if (this.MergeInfoView.RowCount > 0)
                    {
                        try
                        {
                            this.MergeInfoView.Columns[this.MergeInfoView.ColumnCount - 1].Width = LOG_COLUMN_WIDTH;
                        }
                        catch (Exception e)
                        {
                            //empty invalidation display catch
                        }
                    }
                    this.MergeInfoView.Refresh();
                }

                if (ihiInfoTabShow)
                {
                    this.ihiLookupInfoSource.DataSource = hipsInfo.GetIHILookupInfo();
                    this.ihiLookupInfoView.DataSource = this.ihiLookupInfoSource;
                    if (this.ihiLookupInfoView.RowCount > 0)
                    {
                        try
                        {
                            this.ihiLookupInfoView.Columns[this.ihiLookupInfoView.ColumnCount - 1].Width = LOG_COLUMN_WIDTH;
                        }
                        catch (Exception e)
                        {
                            //empty invalidation display catch
                        }
                    }
                    this.ihiLookupInfoView.Refresh();
                }

                if (pcehrInfoTabShow)
                {
                    this.pcehrInfoSource.DataSource = hipsInfo.GetPcehrInfoMessages();
                    this.pcehrInfoView.DataSource = this.pcehrInfoSource;
                    if (this.pcehrInfoView.RowCount > 0)
                    {
                        try
                        {
                            this.pcehrInfoView.Columns[this.pcehrInfoView.ColumnCount - 1].Width = LOG_COLUMN_WIDTH;
                        }
                        catch (Exception e)
                        {
                            //empty invalidation display catch
                        }
                    }
                    this.pcehrInfoView.Refresh();
                }

                if (backgroundProcessorTabShow)
                {
                    this.backgroundProcessorSource.DataSource = hipsInfo.GetBackGroundProcessorMessages();
                    this.backgroundProcessorView.DataSource = this.backgroundProcessorSource;
                    if (this.backgroundProcessorView.RowCount > 0)
                    {
                        try
                        {
                            this.backgroundProcessorView.Columns[this.backgroundProcessorView.ColumnCount - 1].Width = LOG_COLUMN_WIDTH;
                        }
                        catch (Exception e)
                        {
                            //empty invalidation display catch
                        }
                    }
                    this.backgroundProcessorView.Refresh();
                }

                if (msmqInfoTabShow)
                {
                    this.msmqInfoSource.DataSource = hipsInfo.GetMsmqMessages();
                    this.msmqInfoView.DataSource = this.msmqInfoSource;
                    if (this.msmqInfoView.RowCount > 0)
                    {
                        try
                        {
                            this.msmqInfoView.Columns[this.msmqInfoView.ColumnCount - 1].Width = LOG_COLUMN_WIDTH;
                        }
                        catch (Exception e)
                        {
                            //empty invalidation display catch
                        }
                    }
                    this.msmqInfoView.Refresh();
                }

                if (pumaErrorsTabShow)
                {
                    this.pumaErrorSource.DataSource = hipsInfo.GetPumaErrorMessages();
                    this.pumaErrorView.DataSource = this.pumaErrorSource;
                    if (this.pumaErrorView.RowCount > 0)
                    {
                        try
                        {
                            this.pumaErrorView.Columns[this.pumaErrorView.ColumnCount - 1].Width = LOG_COLUMN_WIDTH;
                        }
                        catch (Exception e)
                        {
                            //empty invalidation display catch
                        }
                    }
                    this.pumaErrorView.Refresh();
                }

                if (pcehrUploadErrorsTabShow)
                {
                    this.pcehrUploadErrorSource.DataSource = hipsInfo.GetPcehrUploadErrors();
                    this.pcehrUploadErrorView.DataSource = this.pcehrUploadErrorSource;
                    this.pcehrUploadErrorView.Refresh();
                }

                if (pcehrUploadedDocumentTabShow)
                {
                    this.pcehrUploadedDocumentsSource.DataSource = hipsInfo.GetPcehrUploadedDocuments();
                    this.pcehrUploadedDocumentsView.DataSource = this.pcehrUploadedDocumentsSource;
                    this.pcehrUploadedDocumentsView.Refresh();
                }

                
            }
        }

        private void refreshData()
        {
            Cursor.Current = Cursors.WaitCursor;
            ihiAlertTimer.Stop();
            pasTimer.Stop();
            DateTime start = DateTime.Now;
            try
            {

                String storedNotifyIconText = notifyIcon.Text;
                notifyIcon.Text = "";
                //notifyIcon.Icon = HipsMonitoring.Properties.Resources.TimeIcon;
                hipsInfo.Refresh();
                
                PasCount();
                LookupAverage();
                PcehrLookupAverage();

                IhiAlert();
                PcehrAlert();
                PasErrorMessageCount();
                PcehrFailedUpdate();
                PcehrPendingUpdate();
                ConsentServiceUpdate();

                setDataSources();

                updatePage();

                //if the notify has not chanaged then use the last one
                if (notifyIcon.Text.Equals("") && !greenFlag)
                {
                    notifyIcon.Text = storedNotifyIconText;
                }

                //better way to set the notify icon colour
                InfoMessages info = null;
                bool orangeIcon = false;
                bool greenIcon = false;
                for (int i = 0; i <= 8; i++)
                {
                    info = (InfoMessages)mainGridView.Rows[i].DataBoundItem;
                    if (info.Image.Tag != null)
                    {
                        if (info.Image.Tag.Equals(DashboardForm.RED))
                        {
                            //set to red and break out immediately
                            greenIcon = orangeIcon = false;
                            notifyIcon.Icon = HipsMonitoring.Properties.Resources.ErrorIcon;
                            break;
                        }
                        else if (info.Image.Tag.Equals(DashboardForm.ORANGE))
                        {
                            //set to orange and wait for red - if set
                            orangeIcon = true;
                        }
                        else if (info.Image.Tag.Equals(DashboardForm.GREEN))
                        {
                            //set to orange and wait for red - if set
                            greenIcon = true;
                        }
                    }
                }
                //check if orange or green
                if (orangeIcon)
                {
                    notifyIcon.Icon = HipsMonitoring.Properties.Resources.orange;
                }
                else if (greenIcon)
                {
                    notifyIcon.Icon = HipsMonitoring.Properties.Resources.green;
                    notifyIcon.Text = "HIPS Monitoring - All Green";

                }

                this.mainGridView.Refresh();
                redError = false;
                orangeWarning = false;


            }
            catch (SqlException ex)
            {
                MessageBox.Show(ex.Message, "Invalid database Login");

                this.Close();
            }
            catch (Exception ex)
            {

                MessageBox.Show(ex.Message);
            }

            double refreshTime = DateTime.Now.Subtract(start).Milliseconds;
            toolStripStatusLabelUpdate.Text = "Last full refresh took " + refreshTime + "ms";
            pasTimer.Start();
            ihiAlertTimer.Start();

            Cursor.Current = Cursors.Default;
            toolStripStatusLabelUpdate.Text = "Last Update " + DateTime.Now;
            this.Refresh();
        }

        private void pasTimer_Tick(object sender, EventArgs e)
        {
            //PasCount();
        }

        private void ihiLookupAverageTimer_Tick(object sender, EventArgs e)
        {
            //LookupAverage();
        }

        private void ihiAlertTimer_Tick(object sender, EventArgs e)
        {
            refreshData();
        }

        private void DashboardForm_Resize(object sender, EventArgs e)
        {
            if (this.WindowState == FormWindowState.Minimized)
            {
                this.WindowState = FormWindowState.Normal;
                this.Hide();
                shown = false;
            }
        }

        private void DashboardForm_SizeChanged(object sender, EventArgs e)
        {

            if (this.WindowState == FormWindowState.Minimized)
            {
                this.WindowState = FormWindowState.Normal;
                this.Hide();
                shown = false;
            }

        }

        private void DashboardForm_FormClosing(object sender, FormClosingEventArgs e)
        {

            DialogResult result = MessageBox.Show("Are you sure you want to close and quit the Monitoring Application?", "Shutdown", MessageBoxButtons.OKCancel, MessageBoxIcon.Exclamation);

            if (result == DialogResult.Cancel)
            {
                e.Cancel = true;
            }
        }

        private void showErrorsButton_Click(object sender, EventArgs e)
        {
            Cursor.Current = Cursors.WaitCursor;

            tabListInfoLabel.Show();
            displayAllErrorsLabel.Show();
            displaysLastDaysLabel.Show();
            listDisplayCount.Show();
            limitComboLabel.Show();
            limitTabLabel.Show();

            hideErrorsButton.Show();
            showErrorsButton.Hide();
            
            //perform a refresh
            setDataSources();

            this.MinimumSize = new System.Drawing.Size(MIN_WINDOW_WIDTH, MIN_WINDOW_SHOWERROR_HEIGHT);
            this.MaximumSize = new System.Drawing.Size(MAX_WINDOW_WIDTH, MAX_WINDOW_HEIGHT);
            this.Height = 690;
            this.Location = new Point(Screen.PrimaryScreen.WorkingArea.Width - this.Width, Screen.PrimaryScreen.WorkingArea.Height - this.Height);


            Cursor.Current = Cursors.Default;
        }

        private void hideErrorsButton_Click(object sender, EventArgs e)
        {
            hideErrors();
        }

        private void hideErrors()
        {
            tabListInfoLabel.Hide();
            displayAllErrorsLabel.Hide();
            displaysLastDaysLabel.Hide();
            listDisplayCount.Hide();
            limitComboLabel.Hide();
            limitTabLabel.Hide();

            this.MaximumSize = new System.Drawing.Size(MAX_WINDOW_WIDTH, MIN_WINDOW_HEIGHT);
            this.MinimumSize = new System.Drawing.Size(MIN_WINDOW_WIDTH, MIN_WINDOW_HEIGHT);

            hideErrorsButton.Hide();
            showErrorsButton.Show();
            this.Height = MIN_WINDOW_HEIGHT;
            this.Location = new Point(Screen.PrimaryScreen.WorkingArea.Width - this.Width, Screen.PrimaryScreen.WorkingArea.Height - this.Height);
        }

        private void snoozeButton_Click(object sender, EventArgs e)
        {
            if (snoozeButton.Text == "Snooze")
            {
                DialogResult dialogResult = MessageBox.Show("Are you sure that you want to disable all alert messages for 30 minutes?", "Snooze Alerts", MessageBoxButtons.YesNo);
                if (dialogResult == DialogResult.Yes)
                {
                    snoozeTimer.Start();
                    snoozing = true;
                    snoozeButton.Width = 83;
                    snoozeButton.Location = new Point(hideErrorsButton.Location.X - snoozeButton.Width - 7, snoozeButton.Location.Y);
                    snoozeButton.Text = "Un-snooze";
                }
            }
            else
            {
                //turn off snoozing
                snoozeTimer.Stop();
                snoozing = false;
                snoozeButton.Visible = false;
                snoozeButton.Width = 70;
                snoozeButton.Location = new Point(hideErrorsButton.Location.X - snoozeButton.Width - 7 , snoozeButton.Location.Y);
                snoozeButton.Text = "Snooze";
                alertAcknowledgedIhiConnFailure = true;
                alertAcknowledgedPcehrConnFailure = true;
                alertAcknowledgedPasError = true;
                alertAcknowledgedPasCount = true;
                alertAcknowledgedPcehrQueueFailure = true;
                alertAcknowledgedPcehrQueuePending = true;
                alertAcknowledgedConsentServiceFailure = true;
            }

        }

        private void snoozeTimer_Tick(object sender, EventArgs e)
        {
            //turn off snoozing
            snoozeTimer.Stop();
            snoozing = false;
            alertAcknowledgedIhiConnFailure = false;
            alertAcknowledgedPcehrConnFailure = false;
            alertAcknowledgedPasError = false;
            alertAcknowledgedPasCount = false;
            alertAcknowledgedPcehrQueueFailure = false;
            alertAcknowledgedPcehrQueuePending = false;
            alertAcknowledgedConsentServiceFailure = false;

            snoozeButton.Visible = false;
            snoozeButton.Width = 70;
            snoozeButton.Location = new Point(317, snoozeButton.Location.Y);
            snoozeButton.Text = "Snooze";
        }

        private void DashboardForm_Deactivate(object sender, EventArgs e)
        {
            shown = false;
        }

        private void DashboardForm_Activated(object sender, EventArgs e)
        {
            shown = true;
            alertAcknowledgedIhiConnFailure = true;
            alertAcknowledgedPcehrConnFailure = true;
            alertAcknowledgedPasError = true;
            alertAcknowledgedPasCount = true;
            alertAcknowledgedPcehrQueueFailure = true;
            alertAcknowledgedPcehrQueuePending = true;
            alertAcknowledgedConsentServiceFailure = true;
        }

        private void AddNotifyText(String text)
        {
            notifyIcon.Text = text;
        }

        private void ShowNotification(string text, string balloonText)
        {
            redError = true;
            //notifyIcon.Icon = HipsMonitoring.Properties.Resources.ErrorIcon;

            notifyIcon.BalloonTipText = balloonText;
            notifyIcon.BalloonTipIcon = ToolTipIcon.Error;

            AddNotifyText(text);

            //stop showing messages if snoozing
            if (!snoozing && !shown)
            {
                showSnooze = true;
                snoozeButton.Visible = true;
                notifyIcon.ShowBalloonTip(2000, notifyIcon.Text, notifyIcon.BalloonTipText, ToolTipIcon.Error);
            }
        }


        private void pcehrUploadErrors_DoubleClick(object sender, EventArgs e)
        {
            //get the PcehrMessageQueueId
            if (pcehrUploadErrorView != null)
            {
                if (pcehrUploadErrorView.RowCount > 0)
                {
                    int pcehrMessageQueueId = (int)pcehrUploadErrorView.CurrentRow.Cells[7].Value;
                    if (pcehrMessageQueueId != 0)
                    {
                        string folderName = "";

                        this.folderBrowserDialog = new System.Windows.Forms.FolderBrowserDialog();
                        folderBrowserDialog.ShowNewFolderButton = true;
                        folderBrowserDialog.Description = "Select a location to save the decoded CDA zip file";
                        //set the last path that was used
                        if (savedPath != null)
                        {
                            folderBrowserDialog.SelectedPath = savedPath;
                        }
                        if (folderBrowserDialog.ShowDialog() == DialogResult.OK)
                        {
                            
                            folderName = folderBrowserDialog.SelectedPath;
                            //store for next usage
                            savedPath = folderName;

                            string fileName = folderName + "\\PcehrMessage_CDA_" + pcehrMessageQueueId.ToString() + ".zip";

                            try
                            {
                                if (hipsInfo.GetPcehrFailedUploadDocument(fileName, pcehrMessageQueueId))
                                {
                                    MessageBox.Show(fileName + " successfully saved", "Saved", MessageBoxButtons.OK, MessageBoxIcon.Information);
                                }
                            }
                            catch (Exception fne)
                            {
                                MessageBox.Show("Saving File Failure: \n" + fne.Message + "\n" + fne.StackTrace, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                            }
                        }

                       
                    }
                }
                
            }
            
        }

        protected override void OnPaint(PaintEventArgs e) { }

        private void listDisplayCount_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (hipsInfo != null)
            {
                hipsInfo.MaxListDisplay = (string)listDisplayCount.SelectedItem;
            }
        }


    }
}

