﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.ComponentModel;

namespace HipsMonitoring
{
    public class InfoMessages : INotifyPropertyChanged
    {
        private string message;
        private string result;
        private Bitmap image = Properties.Resources.ActivityMonitoricon;
      
        public string Message 
        { 
            get 
            { 
                return message;
            } 
            set 
            { 
                this.message = value;
                RaisePropertyChanged("Message");
            }
        }
        public string Result
        {
            get
            {
                return this.result;
            }
            set
            {
                this.result = value;
                RaisePropertyChanged("Result");
            }
        }
        public Bitmap Image
        {
            get
            {
                return image;
            }
            set
            {
                this.image = value;
                RaisePropertyChanged("Image");
            }
        }
        
        public InfoMessages(string message, string result)
        {
            this.message = message;
            this.result = result;
         
           
        }
        #region Implement INotifyPropertyChanged
        public event PropertyChangedEventHandler PropertyChanged;
        public void RaisePropertyChanged(string propertyName)
        {
            PropertyChangedEventHandler handler = PropertyChanged;
            if (handler != null) handler(this, new PropertyChangedEventArgs(propertyName));
        }
        #endregion

    }
}
