﻿#region Using Directives
using System;
using System.Transactions;
using System.Collections;
using PUMA.ServiceContracts.ServiceInterface;
using PUMA.PcehrDataStore.DataAccess;
using System.Security.Permissions;
#endregion

namespace PUMA.AppServer.ServiceHost
{
    /// <summary>
    /// Allows for auditing within the application.
    /// </summary>
    public class AuditService : BaseService, IAuditService
    {
        /// <summary>
        /// Inserts the specified MRN.
        /// </summary>
        /// <param name="mrn">The MRN.</param>
        /// <param name="medicareNumber">The medicare number.</param>
        /// <param name="medicareNumberSequence">The medicare number sequence.</param>
        /// <param name="name">The name.</param>
        /// <param name="deviceId">The device id.</param>
        /// <param name="userId">The user id.</param>
        /// <param name="episoideId">The episoide id.</param>
        /// <returns></returns>
        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public bool Insert(string mrn, string medicareNumber, string medicareNumberSequence, string name, string deviceId, int? episoideId)
        {
            AuditDl auditDl = new AuditDl();
            return auditDl.Insert(mrn, medicareNumber, medicareNumberSequence, name, deviceId, Helpers.SecurityHelper.GetUserDetail().Login, episoideId);
        }
    }
}

