﻿#region Using Directives
using System;
using System.Transactions;
using System.Collections;
using PUMA.ServiceContracts.ServiceInterface;
using System.Collections.Generic;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrDataStore.DataAccess;
using System.Security.Permissions;
#endregion

namespace PUMA.AppServer.ServiceHost
{
    /// <summary>
    /// 
    /// 
    /// 
    /// </summary>
    public class CountryService : BaseService, ICountryService
    {

        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public List<Country> GetAll()
        {
            CountryDl dataAccess = new CountryDl();
            return dataAccess.GetAll();
        }

        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public List<Country> GetAllByDate(DateTime? lastUpdated)
        {
            CountryDl dataAccess = new CountryDl();
            return dataAccess.GetAll(lastUpdated);
        }

        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public Country Get(int countryId)
        {
            CountryDl dataAccess = new CountryDl();
            return dataAccess.Get(countryId);
        }

    }
}

