﻿#region Using Directives
using System;
using System.Transactions;
using System.Collections;
using PUMA.ServiceContracts.ServiceInterface;
using PUMA.PcehrDataStore.Schemas;
using System.Collections.Generic;
using PUMA.PcehrDataStore.DataAccess;
using System.Security.Permissions;
#endregion

namespace PUMA.AppServer.ServiceHost
{
    /// <summary>
    /// 
    /// 
    /// 
    /// </summary>
    public class DiagnosisRelatedGroupService : BaseService, IDiagnosisRelatedGroupService
    {
        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public List<DiagnosisRelatedGroup> GetAll()
        {
            DiagnosisRelatedGroupDl dataAccess = new DiagnosisRelatedGroupDl();
            return dataAccess.GetAll();
        }

        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public bool Save(DiagnosisRelatedGroup item)
        {
            DiagnosisRelatedGroupDl dataAccess = new DiagnosisRelatedGroupDl();
            if (item.Id == null)
            {
                return dataAccess.Insert(item);
            }
            else
            {
                return dataAccess.Update(item);
            }
        }

        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public bool Delete(DiagnosisRelatedGroup item)
        {
            DiagnosisRelatedGroupDl dataAccess = new DiagnosisRelatedGroupDl();
            return dataAccess.Delete(item);
        }
    }
}

