﻿#region Using Directives
using System;
using System.Transactions;
using System.Collections;
using PUMA.ServiceContracts.ServiceInterface;
using PUMA.PcehrDataStore.DataAccess;
using PUMA.PcehrDataStore.Schemas;
using System.Collections.Generic;
using System.Security.Permissions;
#endregion

namespace PUMA.AppServer.ServiceHost
{
    /// <summary>
    /// 
    /// 
    /// 
    /// </summary>
    public class DiagnosisService : BaseService, IDiagnosisService
    {
        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public List<Diagnosis> GetAll()
        {
            DiagnosisDl dataAccess = new DiagnosisDl();
            return dataAccess.GetAll();
        }

        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public List<Diagnosis> GetAllByDate(DateTime? lastUpdated)
        {
            DiagnosisDl dataAccess = new DiagnosisDl();
            return dataAccess.GetAll(lastUpdated);
        }

        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public Diagnosis Get(int DiagnosisId)
        {
            DiagnosisDl dataAccess = new DiagnosisDl();
            return dataAccess.Get(DiagnosisId);
        }
    }
}

