﻿#region Using Directives
using System;
using System.Transactions;
using System.Collections;
using PUMA.ServiceContracts.ServiceInterface;
using System.Collections.Generic;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrDataStore.DataAccess;
using PUMA.PcehrDataStore.Schemas;
using PUMA.PcehrDataStore.DataAccess;
using HIPS.CommonSchemas;
using System.Security.Permissions;
#endregion

namespace PUMA.AppServer.ServiceHost
{
    /// <summary>
    /// TODO: Obtain user details properly and pass them into the data access layer.
    /// 
    /// 
    /// </summary>
    public class EpisodeDiagnosisRelatedGroupService : BaseService, IEpisodeDiagnosisRelatedGroupService
    {
        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public List<EpisodeDiagnosisRelatedGroup> GetAll(int? episodeId = null)
        {
            EpisodeDiagnosisRelatedGroupDl dataAccess = new EpisodeDiagnosisRelatedGroupDl(new UserDetails());
            return dataAccess.GetAll(episodeId);
        }

        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public bool Save(EpisodeDiagnosisRelatedGroup episode)
        {
            EpisodeDiagnosisRelatedGroupDl dataAccess = new EpisodeDiagnosisRelatedGroupDl(new UserDetails());
            if (episode.EpisodeId == 0)
            {
                return dataAccess.Insert(episode);
            }
            else
            {
                return dataAccess.Update(episode);
            }
        }

        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public bool Insert(EpisodeDiagnosisRelatedGroup episode)
        {
            EpisodeDiagnosisRelatedGroupDl dataAccess = new EpisodeDiagnosisRelatedGroupDl(new UserDetails());
            return dataAccess.Insert(episode);
        }

        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public bool Update(EpisodeDiagnosisRelatedGroup episode)
        {
            EpisodeDiagnosisRelatedGroupDl dataAccess = new EpisodeDiagnosisRelatedGroupDl(new UserDetails());
            return dataAccess.Update(episode);
        }

        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public bool Delete(EpisodeDiagnosisRelatedGroup episode)
        {
            EpisodeDiagnosisRelatedGroupDl dataAccess = new EpisodeDiagnosisRelatedGroupDl(new UserDetails());
            return dataAccess.Delete(episode);
        }
    }
}

