﻿#region Using Directives
using System;
using System.Transactions;
using System.Collections;
using PUMA.ServiceContracts.ServiceInterface;
using HIPS.PcehrDataStore.DataAccess;
using HIPS.PcehrDataStore.Schemas;
using System.Collections.Generic;
using PUMA.PcehrDataStore.Schemas;
using PUMA.PcehrDataStore.DataAccess;
using HIPS.CommonSchemas;
using System.Security.Permissions;
#endregion

namespace PUMA.AppServer.ServiceHost
{
    /// <summary>
    /// TODO: Obtain user details properly and pass them into the data access layer.
    /// 
    /// 
    /// </summary>
    public class EpisodeDiagnosisService : BaseService, IEpisodeDiagnosisService
    {
        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public List<EpisodeDiagnosis> GetAll(int? episodeId = null)
        {
            EpisodeDiagnosisDl dataAccess = new EpisodeDiagnosisDl(new UserDetails());
            return dataAccess.GetAll(episodeId);
        }

        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public bool Save(EpisodeDiagnosis episode)
        {
            EpisodeDiagnosisDl dataAccess = new EpisodeDiagnosisDl(new UserDetails());
            if (episode.EpisodeId == 0)
            {
                return dataAccess.Insert(episode);
            }
            else
            {
                return dataAccess.Update(episode);
            }
        }

        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public bool Insert(EpisodeDiagnosis episode)
        {
            EpisodeDiagnosisDl dataAccess = new EpisodeDiagnosisDl(new UserDetails());
            return dataAccess.Insert(episode);
           
        }

        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public bool Update(EpisodeDiagnosis episode)
        {
            EpisodeDiagnosisDl dataAccess = new EpisodeDiagnosisDl(new UserDetails());
            return dataAccess.Update(episode);
        }

        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public bool Delete(EpisodeDiagnosis episode)
        {
            EpisodeDiagnosisDl dataAccess = new EpisodeDiagnosisDl(new UserDetails());
            return dataAccess.Delete(episode);
        }
    }
}

