﻿#region Using Directives
using System;
using System.Linq;
using System.Transactions;
using System.Collections;
using PUMA.ServiceContracts.ServiceInterface;
using System.Collections.Generic;
using HIPS.PcehrDataStore.Schemas;
using PUMA.PcehrDataStore.Schemas;
using PUMA.PcehrDataStore.DataAccess;
using System.Collections.ObjectModel;
using PUMA.Helpers;
using System.Security.Permissions;
#endregion

namespace PUMA.AppServer.ServiceHost
{
    /// <summary>
    /// 
    /// 
    /// 
    /// </summary>
    public class EpisodeIhiCheckListService : BaseService, IEpisodeIhiCheckListService
    {
        /// <summary>
        /// Gets all the menu entries.
        /// </summary>
        /// <returns></returns>
        [PrincipalPermission(SecurityAction.Demand, Role = "MissingIHIAccess")]
        public ObservableCollection<EpisodeIhiCheckList> GetAll(int episodeId)
        {
            EpisodeIhiCheckListDl dataAccess = new EpisodeIhiCheckListDl();
            return dataAccess.GetAll(episodeId);
        }

        /// <summary>
        /// Updates/Inserts the specified item.
        /// </summary>
        /// <param name="item">The item.</param>
        /// <returns></returns>
        [PrincipalPermission(SecurityAction.Demand, Role = "MissingIHIAccess")]
        public bool Update(EpisodeIhiCheckList item)
        {
            EpisodeIhiCheckListDl dataAccess = new EpisodeIhiCheckListDl();
            return dataAccess.Update(item);
        }

        /// <summary>
        /// Ihis the investigation completed.
        /// </summary>
        /// <param name="episodeId">The episode id.</param>
        [PrincipalPermission(SecurityAction.Demand, Role = "MissingIHIAccess")]
        public void IhiInvestigationCompleted(int episodeId)
        {
            // Check if all IhiCheckList items have been completed
            ObservableCollection<EpisodeIhiCheckList> checkListItems = GetAll(episodeId);

            int incompleteItems = checkListItems.Count(result => result.MarkForInstantRemoval == false && result.IsChecked == false);
            int completeItems = checkListItems.Count(result => result.MarkForInstantRemoval == true && result.IsChecked == true);
            bool complete = (incompleteItems == 0) || completeItems > 0;

            // If everything is completed then mark the episode as Investigation Complete.
            if (complete)
            {
                EpisodeDl dataAccess = new EpisodeDl(SecurityHelper.GetUserDetail());
                dataAccess.Update(episodeId, true);
            }
        }
    }
}

