﻿#region Using Directives
using System;
using System.Transactions;
using System.Collections;
using PUMA.ServiceContracts.ServiceInterface;
using System.Collections.Generic;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrDataStore.DataAccess;
using System.Security.Permissions;
#endregion

namespace PUMA.AppServer.ServiceHost
{
    /// <summary>
    /// 
    /// 
    /// 
    /// </summary>
    public class EpisodeTypeService : BaseService, IEpisodeTypeService
    {
        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public List<EpisodeType> GetAll()
        {
            EpisodeTypeDl dataAccess = new EpisodeTypeDl();
            return dataAccess.GetAll();
        }

        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public List<EpisodeType> GetAllByDate(DateTime lastUpdated)
        {
            EpisodeTypeDl dataAccess = new EpisodeTypeDl();
            return dataAccess.GetAll(lastUpdated);
        }

        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public EpisodeType Get(int EpisodeTypeId)
        {
            EpisodeTypeDl dataAccess = new EpisodeTypeDl();
            return dataAccess.Get(EpisodeTypeId);
        }
    }
}

