﻿#region Using Directives
using System;
using System.Transactions;
using System.Collections;
using PUMA.ServiceContracts.ServiceInterface;
using PUMA.PcehrDataStore.DataAccess;
using HIPS.Client.Proxy;
using System.ServiceModel;
using HIPS.CommonSchemas;
using HIPS.IhiSchemas.Schemas;
using HIPS.PcehrSchemas;
using PUMA.AppServer.ServiceHost.Services;
//using HIPS.PcehrDataStore.Schemas;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.PcehrDataStore.Schemas.Enumerators;
using System.Security.Permissions;
using HIPS.PcehrHiBusinessLogic.Ihi;
using PUMA.PcehrDataStore.Schemas;
using HIPS.PcehrDataStore.Schemas;
#endregion

namespace PUMA.AppServer.ServiceHost
{
    /// <summary>
    /// 
    /// 
    /// 
    /// </summary>
    public class HIPSService : BaseService, IHIPSService
    {

        /// <summary>
        /// IHIs the search by number.
        /// </summary>
        /// <param name="patientMaster"></param>
        /// <param name="hospitalId">The hospital id.</param>
        /// <param name="message"></param>
        /// <returns></returns>
        /// <exception cref="System.Exception">Connection could not be established</exception>
        [PrincipalPermission(SecurityAction.Demand, Role = "MissingIHIAccess")]
        public bool IHISearchByNumber(PUMA.PcehrDataStore.Schemas.PatientMaster patientMaster, int hospitalId, out string message)
        {
            using (PumaInterfaceProxy proxy = new PumaInterfaceProxy(EndPointResource.PumaInterfaceEndPoint))
            {
                try
                {
                    IhiSearchCriteria searchDetails = SearchHelper.PopulateSearchDetails(patientMaster);
                    HipsIhiResponse response = proxy.IHISearchByNumber(hospitalId, searchDetails, Helpers.SecurityHelper.GetUserDetail());
                    message = response.ReturnMessage;
                    return !string.IsNullOrEmpty(response.IhiNumber);
                }
                catch (EndpointNotFoundException ex)
                {
                    proxy.Abort();
                    throw new Exception("Connection could not be established", ex);
                }
                catch (Exception e)
                {
                    proxy.Abort();
                    throw e;
                }
            }
        }

        /// <summary>
        /// IHIs the search by number and PCEHR check.
        /// </summary>
        /// <param name="patientMaster">The patient master.</param>
        /// <param name="hospitalId">The hospital id.</param>
        /// <param name="message"></param>
        /// <returns></returns>
        /// <exception cref="System.Exception">Connection could not be established</exception>
        [PrincipalPermission(SecurityAction.Demand, Role = "MissingIHIAccess")]
        public bool IHISearchByNumberAndPCEHRCheck(PUMA.PcehrDataStore.Schemas.PatientMaster patientMaster, int hospitalId, out string message)
        {
            using (PumaInterfaceProxy proxy = new PumaInterfaceProxy(EndPointResource.PumaInterfaceEndPoint))
            {
                try
                {
                    IhiSearchCriteria searchDetails = SearchHelper.PopulateSearchDetails(patientMaster);
                    HipsIhiResponse response = proxy.IHISearchByNumberAndPCEHRCheck(hospitalId, searchDetails, Helpers.SecurityHelper.GetUserDetail());
                    message = response.ReturnMessage;
                    return !string.IsNullOrEmpty(response.IhiNumber);
                }
                catch (EndpointNotFoundException ex)
                {
                    proxy.Abort();
                    throw new Exception("Connection could not be established", ex);
                }
                catch (Exception e)
                {
                    proxy.Abort();
                    throw e;
                }
            }
        }

        /// <summary>
        /// Check to see if the Pcehr exists for this IHI.
        /// </summary>
        /// <param name="ihi">The ihi.</param>
        /// <param name="user">The user.</param>
        /// <returns></returns>
        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public DoesPcehrExistResponse PcehrExists(string ihi)
        {
            using (PCEHRProxy proxy = new PCEHRProxy("PCEHREndPoint"))
            {
                try
                {
                    //TODO: To Fix
                    return new DoesPcehrExistResponse();
                    //return proxy.PcehrExistsByIhi(ihi, user);
                }
                catch (EndpointNotFoundException ex)
                {
                    proxy.Abort();
                    throw new Exception("Connection could not be established", ex);
                }
                catch (Exception e)
                {
                    proxy.Abort();
                    throw e;
                }
            }
        }

        /// <summary>
        /// Uploads the PCEHR to the National Record Centre.
        /// </summary>
        /// <param name="package">The package.</param>
        /// <param name="ihi">The ihi.</param>
        /// <param name="user">The user.</param>
        /// <returns></returns>
        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public string PCEHRUpload(string package, string ihi, string parentDocumentId)
        {
            using (PCEHRProxy proxy = new PCEHRProxy("PCEHREndPoint"))
            {
                try
                {
                    //TODO: To Fix
                    return "FIX";
                    //return proxy.Upload(package, ihi, Helpers.SecurityHelper.GetUserDetail(), parentDocumentId);
                }
                catch (EndpointNotFoundException ex)
                {
                    proxy.Abort();
                    throw new Exception("Connection could not be established", ex);
                }
                catch (Exception e)
                {
                    proxy.Abort();
                    throw e;
                }
            }
        }

        /// <summary>
        /// Remove the PCEHR from the National Repository.
        /// </summary>
        /// <param name="documentId">The document id.</param>
        /// <param name="ihi">The ihi.</param>
        /// <param name="reason">The reason.</param>
        /// <param name="user">The user.</param>
        /// <returns></returns>
        [PrincipalPermission(SecurityAction.Demand, Role = "RemoveDischargeAccess")]
        public HipsResponse PcehrRemove(PatientIdentifierBase patientIdentifier, DateTime admissionDate, string documentId, RemovalReason reason, byte[] auditInformation)
        {
            using (PCEHRProxy proxy = new PCEHRProxy("PCEHREndPoint"))
            {
                try
                {
                    HipsResponse response = proxy.Remove(patientIdentifier, admissionDate, documentId, reason, Helpers.SecurityHelper.GetUserDetail(), auditInformation);

                    return response;
                }
                catch (EndpointNotFoundException ex)
                {
                    proxy.Abort();
                    throw new Exception("Connection could not be established", ex);
                }
                catch (Exception e)
                {
                    proxy.Abort();
                    throw e;
                }
            }
        }

        /// <summary>
        /// Gets the current remove reason.
        /// </summary>
        /// <param name="clinicalDocumentId">The clinical document id.</param>
        /// <returns></returns>
        [PrincipalPermission(SecurityAction.Demand, Role = "RemoveDischargeAccess")]
        public string GetCurrentRemoveReason(int clinicalDocumentId)
        {
            string result = string.Empty;

            RemoveAuditDl removeDl = new RemoveAuditDl();
            RemoveAudit removeAudit = removeDl.GetCurrentRemoveAudit(clinicalDocumentId);

            if (removeAudit.AuditInformation != null)
            {
                result = System.Text.Encoding.UTF8.GetString(removeAudit.AuditInformation);
            }

            return result;
        }
    }
}

