﻿#region Using Directives
using System;
using System.Transactions;
using System.Collections;
using PUMA.ServiceContracts.ServiceInterface;
using System.Collections.Generic;
using HIPS.PcehrDataStore.Schemas;
using System.Collections.ObjectModel;
using PUMA.PcehrDataStore.Schemas;
using PUMA.PcehrDataStore.DataAccess;
using HIPS.CommonSchemas;
using System.Security.Permissions;
#endregion

namespace PUMA.AppServer.ServiceHost
{
    /// <summary>
    /// 
    /// 
    /// 
    /// </summary>
    public class HospitalService : BaseService, IHospitalService
    {

        /// <summary>
        /// Gets the active hospitals.
        /// </summary>
        /// <returns>List of Hips hospital objects</returns>
        //[PrincipalPermission(SecurityAction.Demand, Role = "SystemAccess")]
        public List<Hospital> GetActive()
        {
            HospitalDl dataAccess = new HospitalDl();
            
            List<Hospital> hospitals = dataAccess.GetActive();

            return hospitals;
        }

        [PrincipalPermission(SecurityAction.Demand, Role = "SystemAccess")]
        public List<Hospital> GetAll()
        {
            HospitalDl dataAccess = new HospitalDl();
            return dataAccess.GetAll();
        }

        [PrincipalPermission(SecurityAction.Demand, Role = "SystemAccess")]
        public List<Hospital> GetAllByDate(DateTime? lastUpdated)
        {
            HospitalDl dataAccess = new HospitalDl();
            return dataAccess.GetAll(lastUpdated);
        }

        [PrincipalPermission(SecurityAction.Demand, Role = "SystemAccess")]
        public Hospital Get(int hospitalId)
        {
            HospitalDl dataAccess = new HospitalDl();
            return dataAccess.Get(hospitalId);
        }

        /// <summary>
        /// Gets all the wards with the selected Hospital or all hospitals if the id is null.
        /// </summary>
        /// <param name="hospitalId">The hospital id.</param>
        /// <returns></returns>
        //[PrincipalPermission(SecurityAction.Demand, Role = "SystemAccess")]
        public ObservableCollection<HospitalWard> GetAllWards(int? hospitalId)
        {
            HospitalWardDl dataAccess = new HospitalWardDl();
            return dataAccess.GetAll(hospitalId);
        }
    }
}

