﻿#region Using Directives
using System;
using System.Transactions;
using System.Collections;
using PUMA.ServiceContracts.ServiceInterface;
using System.Collections.Generic;
using PUMA.PcehrDataStore.Schemas;
using PUMA.PcehrDataStore.DataAccess;
using System.Security.Permissions;
#endregion

namespace PUMA.AppServer.ServiceHost
{
    /// <summary>
    /// 
    /// 
    /// 
    /// </summary>
    public class IcdProcedureCodeService : BaseService, IIcdProcedureCodeService
    {
        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public List<IcdProcedureCode> GetAll()
        {
            IcdProcedureCodeDl dataAccess = new IcdProcedureCodeDl();
            return dataAccess.GetAll();
        }

        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public IcdProcedureCode Get(int IcdProcedureCodeId)
        {
            IcdProcedureCodeDl dataAccess = new IcdProcedureCodeDl();
            return dataAccess.Get(IcdProcedureCodeId);
        }

        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public bool Save(IcdProcedureCode item)
        {
            IcdProcedureCodeDl dataAccess = new IcdProcedureCodeDl();
            if (item.Id == null)
            {
                return dataAccess.Insert(item);
            }
            else
            {
                return dataAccess.Update(item);
            }
        }

        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public bool Delete(IcdProcedureCode item)
        {
            IcdProcedureCodeDl dataAccess = new IcdProcedureCodeDl();
            return dataAccess.Delete(item);
        }
    }
}

