﻿#region Using Directives
using System;
using System.Transactions;
using System.Collections;
using PUMA.ServiceContracts.ServiceInterface;
using System.Collections.Generic;
using HIPS.PcehrDataStore.DataAccess;
using HIPS.PcehrDataStore.Schemas;
using PUMA.PcehrDataStore.Schemas;
using System.Security.Permissions;
#endregion

namespace PUMA.AppServer.ServiceHost
{
    /// <summary>
    /// 
    /// 
    /// 
    /// </summary>
    public class IndigenousStatusService : BaseService, IIndigenousStatusService
    {
        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public List<IndigenousStatus> GetAll()
        {
            IndigenousStatusDl dataAccess = new IndigenousStatusDl();
            return dataAccess.GetAll();
        }

        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public List<IndigenousStatus> GetAllByDate(DateTime? lastUpdated)
        {
            IndigenousStatusDl dataAccess = new IndigenousStatusDl();
            return dataAccess.GetAll(lastUpdated);
        }

        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public IndigenousStatus Get(int indigenousStatusId)
        {
            IndigenousStatusDl dataAccess = new IndigenousStatusDl();
            return dataAccess.Get(indigenousStatusId);
        }
    }
}

