﻿#region Using Directives
using System;
using System.Transactions;
using System.Collections;
using PUMA.ServiceContracts.ServiceInterface;
using HIPS.PcehrDataStore.Schemas;
using System.Collections.Generic;
using HIPS.PcehrDataStore.DataAccess;
using PUMA.PcehrDataStore.Schemas;
using System.Security.Permissions;
#endregion

namespace PUMA.AppServer.ServiceHost
{
    /// <summary>
    /// 
    /// 
    /// 
    /// </summary>
    public class PathologyService : BaseService, IPathologyService
    {
        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public List<Pathology> GetAll(int? patientId, DateTime? lastUpdate)
        {
            PathologyDl dataAccess = new PathologyDl();
            return dataAccess.GetAll(patientId, lastUpdate);
        }

        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public bool Save(Pathology item)
        {
            PathologyDl dataAccess = new PathologyDl();
            if (item.Id == null)
            {
                return dataAccess.Insert(item);
            }
            else
            {
                return dataAccess.Update(item);
            }
        }

        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public bool Delete(Pathology item)
        {
            PathologyDl dataAccess = new PathologyDl();
            return dataAccess.Delete(item);
        }

    }
}

