﻿#region Using Directives
using System;
using System.Transactions;
using System.Collections;
using PUMA.ServiceContracts.ServiceInterface;
//using HIPS.PcehrDataStore.DataAccess;
using System.Collections.Generic;
using HIPS.CommonSchemas;
using System.Collections.ObjectModel;
using PUMA.PcehrDataStore.Schemas;
using PUMA.PcehrDataStore.DataAccess;
using System.Security.Permissions;
using System.Threading;
using System.Configuration;
using PUMA.Helpers;
#endregion

namespace PUMA.AppServer.ServiceHost
{
    /// <summary>
    /// 
    /// 
    /// 
    /// </summary>
    public class PatientMasterService : BaseService, IPatientMasterService
    {

        /// <summary>
        /// Gets the specified hospital ID.
        /// </summary>
        /// <param name="hospitalID">The hospital ID.</param>
        /// <param name="mrn">The MRN.</param>
        /// <param name="namespaceId">The namespace id.</param>
        /// <param name="currentLastName">Last name of the current.</param>
        /// <param name="currentFirstNames">The current first names.</param>
        /// <param name="dateOfBirth">The date of birth.</param>
        /// <param name="sexID">The sex ID.</param>
        /// <param name="medicareNumber">The medicare number.</param>
        /// <param name="medicareNumberSequence">The medicare number sequence.</param>
        /// <param name="dvaNumber">The dva number.</param>
        /// <param name="onlyCountryPatients">The only country patients.</param>
        /// <param name="item">The item.</param>
        /// <returns></returns>
        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public bool Get(int hospitalID, string mrn, int? namespaceId, string currentLastName, string currentFirstNames, DateTime? dateOfBirth, int? sexID, string medicareNumber, string medicareNumberSequence, string dvaNumber, bool? onlyCountryPatients, out PatientMaster item)
        {
            PatientMasterDl dataAccess = new PatientMasterDl(new UserDetails());
            //TODO: To Fix
            item = new PatientMaster();
            return false;
            //return dataAccess.Get(hospitalID, mrn,namespaceId, currentLastName, currentFirstNames, dateOfBirth, sexID, medicareNumber, medicareNumberSequence, dvaNumber,onlyCountryPatients, out item);
        }

        /// <summary>
        /// Gets all.
        /// </summary>
        /// <param name="hospitalId">The hospital id.</param>
        /// <param name="ward">The ward.</param>
        /// <param name="onlyShowPatientsNeededAManualIhiSearch">The only show patients needed A manual ihi search.</param>
        /// <param name="dischargeDate">The discharge date.</param>
        /// <param name="pcehrPatients">if set to <c>true</c> [pcehr patients].</param>
        /// <param name="withoutPcehrPatients">if set to <c>true</c> [non-pcehr patients].</param>
        /// <returns></returns>
        [PrincipalPermission(SecurityAction.Demand, Role = "MissingIHIAccess, ManageConsentAccess, DisclosePcehrAccess, RemoveDischargeAccess")]
        public ObservableCollection<PatientTile> GetAll(int? hospitalId, string ward, bool? onlyShowPatientsNeededAManualIhiSearch, bool pcehrPatients, bool withoutPcehrPatients)
        {
            DateTime dischargeDate;
            int daysAfterDischarge;

            daysAfterDischarge = Int32.Parse(ConfigurationManager.AppSettings["DaysAfterDischarge"]);

            dischargeDate = DateTime.Now.AddDays(-daysAfterDischarge);

            PatientTileDl dataAccess = new PatientTileDl();
            ObservableCollection<PatientTile> results = dataAccess.GetAll(hospitalId, ward, onlyShowPatientsNeededAManualIhiSearch, dischargeDate, pcehrPatients, withoutPcehrPatients);
            return results;
        }

        /// <summary>
        /// Gets all pcehr by hospital.
        /// </summary>
        /// <param name="hospitalId">The hospital id.</param>
        /// <returns></returns>
        [PrincipalPermission(SecurityAction.Demand, Role = "ViewAdvertisedPcehr")]
        //[PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public ObservableCollection<PatientTile> GetAllPcehrByHospital(int hospitalId)
        {
            return this.GetAll(hospitalId, string.Empty, null, true, false);
        }

        /// <summary>
        /// Gets all pcehr by hospital.
        /// </summary>
        /// <param name="hospitalId">The hospital id.</param>
        /// <returns></returns>
        [PrincipalPermission(SecurityAction.Demand, Role = "AssistedRegistrationAccess")]
        //[PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public ObservableCollection<PatientTile> GetAllWithoutPcehrByHospital(int hospitalId)
        {
            return this.GetAll(hospitalId, string.Empty, null, false, true);
        }

        /// <summary>
        /// Gets the by id.
        /// </summary>
        /// <param name="patientMasterID">The patient master ID.</param>
        /// <param name="item">The item.</param>
        /// <returns></returns>
        [PrincipalPermission(SecurityAction.Demand, Role = "MissingIHIAccess")]
        public bool GetById(int patientMasterID, out PatientMaster item)
        {
            PatientMasterDl dataAccess = new PatientMasterDl(new UserDetails());
            return dataAccess.Get(patientMasterID, out item);
        }

        /// <summary>
        /// Gets the patient by MRN.
        /// </summary>
        /// <param name="hospitalId">The hospital id.</param>
        /// <param name="mrn">The MRN.</param>
        /// <returns></returns>
        [PrincipalPermission(SecurityAction.Demand, Role = "RemoveDischargeAccess")]
        public ObservableCollection<PatientTile> GetByMrn(int hospitalId, string mrn)
        {
            PatientTileDl dataAccess = new PatientTileDl();
            ObservableCollection<PatientTile> results = dataAccess.GetByMrn(hospitalId, mrn);
            return results;
        }

        /// <summary>
        /// Saves the specified item.
        /// </summary>
        /// <param name="item">The item.</param>
        /// <returns></returns>
        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public bool Save(PatientMaster item)
        {
            PatientMasterDl dataAccess = new PatientMasterDl(new UserDetails());
            if (item.Id == null)
            {
                return dataAccess.Insert(item);
            }
            else
            {
                return dataAccess.Update(item);
            }
        }

        /// <summary>
        /// Deletes the specified item.
        /// </summary>
        /// <param name="item">The item.</param>
        /// <returns></returns>
        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public bool Delete(PatientMaster item)
        {
            PatientMasterDl dataAccess = new PatientMasterDl(new UserDetails());
            return dataAccess.Delete(item);
        }
    }
}

