﻿#region Using Directives
using System;
using System.Transactions;
using System.Collections;
using System.Collections.Generic;
using PUMA.ServiceContracts.ServiceInterface;
using HIPS.PcehrDataStore.DataAccess;
using HIPS.PcehrDataStore.Schemas;
using HIPS.CommonSchemas;
using System.Security.Permissions;
#endregion

namespace PUMA.AppServer.ServiceHost
{
    /// <summary>
    /// 
    /// 
    /// 
    /// </summary>
    public class PcehrService : BaseService, IPcehrService
    {
        /// <summary>
        /// Gets all.
        /// </summary>
        /// <returns></returns>
        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public List<ClinicalDocument> GetAll()
        {
            ClinicalDocumentDl dataAccess = new ClinicalDocumentDl(new UserDetails());
            //TODO: Fix this to return which documents are required, not all of them!
            //return dataAccess.GetAll();
            return new List<ClinicalDocument>();
        }

        /// <summary>
        /// Gets the specified episode ID.
        /// </summary>
        /// <param name="episodeID">The episode ID.</param>
        /// <param name="isPatientKnown">if set to <c>true</c> [is patient known].</param>
        /// <returns></returns>
        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public ClinicalDocument Get(int episodeID, bool isPatientKnown)
        {
            ClinicalDocumentDl dataAccess = new ClinicalDocumentDl(new UserDetails());
            //TODO: To Fix
            return new ClinicalDocument();
            //return dataAccess.Get(episodeID, isPatientKnown);
        }

        /// <summary>
        /// Saves the specified pcehr.
        /// </summary>
        /// <param name="pcehr">The pcehr.</param>
        /// <returns></returns>
        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public bool Save(ref ClinicalDocument clinicalDocument)
        {
            ClinicalDocumentDl dataAccess = new ClinicalDocumentDl(new UserDetails());
            //TODO: To Fix
            return false;
            //return dataAccess.Save(clinicalDocument);
        }

        /// <summary>
        /// Determines whether [is database available].
        /// </summary>
        /// <returns>
        ///   <c>true</c> if [is database available]; otherwise, <c>false</c>.
        /// </returns>
        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public bool IsDatabaseAvailable()
        {
            ClinicalDocumentDl dataAccess = new ClinicalDocumentDl(new UserDetails());
            return dataAccess.IsDatabaseAvailable;
        }

        /// <summary>
        /// Supersedes the specified pcehr.
        /// </summary>
        /// <param name="pcehr">The pcehr.</param>
        /// <returns></returns>
        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public bool Supersede(ref ClinicalDocument clinicalDocument)
        {
            ClinicalDocumentDl dataAccess = new ClinicalDocumentDl(new UserDetails());
            //TODO: To Fix
            return false;
            //return dataAccess.Supersede(clinicalDocument);
        }

      
        
    }
}

