﻿#region Using Directives
using System;
using System.Transactions;
using System.Collections;
using PUMA.ServiceContracts.ServiceInterface;
using HIPS.PcehrDataStore.Schemas;
using System.Collections.Generic;
using HIPS.PcehrDataStore.DataAccess;
using PUMA.PcehrDataStore.Schemas;
using System.Security.Permissions;
#endregion

namespace PUMA.AppServer.ServiceHost
{
    /// <summary>
    /// 
    /// 
    /// 
    /// </summary>
    public class ReligionService : BaseService, IReligionService
    {
        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public List<Religion> GetAll()
        {
            ReligionDl dataAccess = new ReligionDl();
            return dataAccess.GetAll();
        }

        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public List<Religion> GetAllByDate(DateTime? lastUpdated)
        {
            ReligionDl dataAccess = new ReligionDl();
            return dataAccess.GetAll(lastUpdated);
        }

        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public Religion Get(int ReligionId)
        {
            ReligionDl dataAccess = new ReligionDl();
            return dataAccess.Get(ReligionId);
        }
    }
}

