﻿#region Using Directives
using System;
using System.Transactions;
using System.Collections;
using PUMA.ServiceContracts.ServiceInterface;
using PUMA.PcehrDataStore.DataAccess;
using PUMA.PcehrDataStore.Schemas;
using System.Collections.Generic;
using PUMA.Helpers;
using System.Security.Permissions;
using PUMA.Operation;
#endregion

namespace PUMA.AppServer.ServiceHost
{
    public class SecurityService : BaseService, ISecurityService
    {
        
        /// <summary>
        /// Logins this instance.
        /// </summary>
        // Do not include Security Demand on this method as we need the unauthenticated user to login.
        //[PrincipalPermission(SecurityAction.Demand, Role = "SystemAccess")]
        public void Login(out string firstName, out string lastName, out string hpii)
        {
            SecurityDl dataAccess = new SecurityDl();

            dataAccess.CreateUserPermission(out firstName, out lastName, out hpii);

            List<string> permissions = dataAccess.GetUserPermission();

            PumaOperationContext.Current.Permissions = permissions;
        }

        /// <summary>
        /// Checks the current security of the user and returns a new set of permissions.
        /// </summary>
        //[PrincipalPermission(SecurityAction.Demand, Role = "SystemAccess")]
        public void Check()
        {
            // This is intentionally blank as the permission will be returned 
            // to the caller via the header.
        }
    }
}
