﻿#region Using Directives
using System;
using System.Transactions;
using System.Collections;
using PUMA.ServiceContracts.ServiceInterface;
using System.Collections.Generic;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrDataStore.DataAccess;
using System.Security.Permissions;
#endregion

namespace PUMA.AppServer.ServiceHost
{
    /// <summary>
    /// 
    /// 
    /// 
    /// </summary>
    public class SexService : BaseService, ISexService
    {
        [PrincipalPermission(SecurityAction.Demand, Role = "SystemAccess")]
        public List<Sex> GetAll()
        {
            SexDl dataAccess = new SexDl();
            return dataAccess.GetAll();
        }

        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public List<Sex> GetAllByDate(DateTime? lastUpdated)
        {
            SexDl dataAccess = new SexDl();
            return dataAccess.GetAll(lastUpdated);
        }

        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public Sex Get(int SexId)
        {
            SexDl dataAccess = new SexDl();
            return dataAccess.Get(SexId);
        }
    }
}

