﻿#region Using Directives
using System;
using System.Transactions;
using System.Collections;
using PUMA.ServiceContracts.ServiceInterface;
using PUMA.PcehrDataStore.Schemas;
using System.Collections.Generic;
using PUMA.PcehrDataStore.DataAccess;
using System.Security.Permissions;
#endregion

namespace PUMA.AppServer.ServiceHost
{
    /// <summary>
    /// 
    /// 
    /// 
    /// </summary>
    public class SpecialityService : BaseService, ISpecialityService
    {
        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public List<Speciality> GetAll()
        {
            SpecialityDl dataAccess = new SpecialityDl();
            return dataAccess.GetAll();
        }

        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public List<Speciality> GetAllByDate(DateTime? lastUpdated)
        {
            SpecialityDl dataAccess = new SpecialityDl();
            return dataAccess.GetAll(lastUpdated);
        }

        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public Speciality Get(int SpecialityId)
        {
            SpecialityDl dataAccess = new SpecialityDl();
            return dataAccess.Get(SpecialityId);
        }
    }
}

