﻿#region Using Directives
using System;
using System.Transactions;
using System.Collections;
using PUMA.ServiceContracts.ServiceInterface;
using HIPS.PcehrDataStore.Schemas;
using System.Collections.Generic;
using HIPS.PcehrDataStore.DataAccess;
using System.Security.Permissions;
#endregion

namespace PUMA.AppServer.ServiceHost
{
    /// <summary>
    /// 
    /// 
    /// 
    /// </summary>
    public class StateService : BaseService, IStateService
    {
        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public List<State> GetAll()
        {
            StateDl dataAccess = new StateDl();
            return dataAccess.GetAll();
        }

        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public List<State> GetAllByDate(DateTime? lastUpdated)
        {
            StateDl dataAccess = new StateDl();
            return dataAccess.GetAll(lastUpdated);
        }

        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public State Get(int StateId)
        {
            StateDl dataAccess = new StateDl();
            return dataAccess.Get(StateId);
        }
    }
}

