﻿#region Using Directives
using System;
using System.Transactions;
using System.Collections;
using PUMA.ServiceContracts.ServiceInterface;
using HIPS.PcehrDataStore.Schemas;
using System.Collections.Generic;
using HIPS.PcehrDataStore.DataAccess;
using System.Security.Permissions;
#endregion

namespace PUMA.AppServer.ServiceHost
{
    /// <summary>
    /// 
    /// 
    /// 
    /// </summary>
    public class SuffixService : BaseService, ISuffixService
    {
        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public List<Suffix> GetAll()
        {
            SuffixDl dataAccess = new SuffixDl();
            return dataAccess.GetAll();
        }

        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public List<Suffix> GetAllByDate(DateTime? lastUpdated)
        {
            SuffixDl dataAccess = new SuffixDl();
            return dataAccess.GetAll(lastUpdated);
        }

        [PrincipalPermission(SecurityAction.Demand, Role = "NoAccess")]
        public Suffix Get(int SuffixId)
        {
            SuffixDl dataAccess = new SuffixDl();
            return dataAccess.Get(SuffixId);
        }
    }
}

