﻿
#region Using Directives
using System.ServiceModel;
using PUMA.ServiceContracts.ServiceInterface;
using HIPS.PcehrDataStore.Schemas;
using System.Collections.Generic;
using System;
using PUMA.PcehrDataStore.Schemas;
using System.Collections.ObjectModel;
#endregion

namespace PUMA.Client.Proxy
{
    /// <summary>
    /// This is the client proxy for the Menu Items
    /// </summary>
    public class EpisodeIhiCheckListProxy : ClientBase<IEpisodeIhiCheckListService>, IEpisodeIhiCheckListService
    {
        /// <summary>
        /// Default constructor
        /// </summary>
        /// <param name="endpointName"></param>
        public EpisodeIhiCheckListProxy(string endpointName)
            : base(endpointName)
        {
        }

        /// <summary>
        /// Gets all.
        /// </summary>
        /// <returns></returns>
        public ObservableCollection<EpisodeIhiCheckList> GetAll(int episodeId)
        {
            return Channel.GetAll(episodeId);
        }

        /// <summary>
        /// Updates/Inserts the specified item.
        /// </summary>
        /// <param name="item">The item.</param>
        /// <returns></returns>
        public bool Update(EpisodeIhiCheckList item)
        {
            return Channel.Update(item);
        }

        /// <summary>
        /// Ihis the investigation completed.
        /// </summary>
        /// <param name="episodeId">The episode id.</param>
        public void IhiInvestigationCompleted(int episodeId)
        {
            Channel.IhiInvestigationCompleted(episodeId);
        }
    }
}
