﻿
#region Using Directives
using System.ServiceModel;
using PUMA.ServiceContracts.ServiceInterface;
using System.Collections.Generic;
using HIPS.PcehrDataStore.Schemas;
using System;
using HIPS.CommonSchemas;
using System.Collections.ObjectModel;
using PUMA.PcehrDataStore.Schemas;
using HIPS.CommonSchemas.PatientIdentifier;
#endregion

namespace PUMA.Client.Proxy
{
    /// <summary>
    /// 
    /// </summary>
    public class EpisodeProxy : ClientBase<IEpisodeService>, IEpisodeService
    {
        /// <summary>
        /// Default constructor
        /// </summary>
        /// <param name="endpointName"></param>
        public EpisodeProxy(string endpointName)
            : base(endpointName)
        {
        }

        /// <summary>
        /// Gets the specified episode id.
        /// </summary>
        /// <param name="episodeId">The episode id.</param>
        /// <returns></returns>
        public EpisodeTile Get(int episodeId)
        {
            return Channel.Get(episodeId);
        }

        /// <summary>
        /// Gets the a list episodes with uploaded documents for a specific patient.
        /// </summary>
        /// <param name="patientId">The patient id.</param>
        /// <param name="startRow">The start row.</param>
        /// <param name="endRow">The end row.</param>
        /// <param name="user">The user.</param>
        /// <returns></returns>
        public ObservableCollection<EpisodeTile> GetEpisodesWithUploadedDocuments(int patientId, int startRow, int endRow)
        {
            return Channel.GetEpisodesWithUploadedDocuments(patientId, startRow, endRow);
        }

        /// <summary>
        /// Gets the count of episodes with uploaded document for the selected patient.
        /// </summary>
        /// <param name="patientId">The patient id.</param>
        /// <param name="user">The user.</param>
        /// <returns></returns>
        public int GetEpisodesWithUploadedDocumentCount(int patientId)
        {
            return Channel.GetEpisodesWithUploadedDocumentCount(patientId);
        }

        /// <summary>
        /// Gets a list of episodes for a specific patient.
        /// </summary>
        /// <param name="patientId">The patient id.</param>
        /// <param name="startRow">The start row.</param>
        /// <param name="endRow">The end row.</param>
        /// <returns></returns>
        public ObservableCollection<EpisodeTile> GetEpisodes(int patientId, int startRow, int endRow)
        {
            return Channel.GetEpisodes(patientId, startRow, endRow);
        }

        /// <summary>
        /// Gets a count of episodes for the selected patient.
        /// </summary>
        /// <param name="patientId">The patient id.</param>
        /// <returns></returns>
        public int GetEpisodesCount(int patientId)
        {
            return Channel.GetEpisodesCount(patientId);
        }

        /// <summary>
        /// Records if the patient has withdrawn their consent to upload documents to the PCEHR for the current episode.
        /// </summary>
        /// <param name="pcehrWithdrawn">if set to <c>true</c> [pcehr withdrawn].</param>
        /// <param name="admissionDate">The admission date.</param>
        /// <param name="patientIdentifier">The patient identifier.</param>
        /// <param name="user">The user.</param>
        /// <param name="auditInformation">The audit information.</param>
        /// <returns></returns>
        public bool RecordConsent(bool pcehrWithdrawn, DateTime admissionDate, PatientIdentifierBase patientIdentifier, byte[] auditInformation)
        {
            return Channel.RecordConsent(pcehrWithdrawn, admissionDate, patientIdentifier, auditInformation);
        }

        /// <summary>
        /// Gets the current consent reason.
        /// </summary>
        /// <param name="episodeId">The episode id.</param>
        /// <returns></returns>
        public string GetCurrentConsentReason(int episodeId)
        {
            return Channel.GetCurrentConsentReason(episodeId);
        }

    }
}
