﻿
#region Using Directives
using System.ServiceModel;
using PUMA.ServiceContracts.ServiceInterface;
using Nehta.VendorLibrary.PCEHR.RemoveDocument;
using HIPS.IhiSchemas.Schemas;
using HIPS.CommonSchemas;
using HIPS.PcehrSchemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;
using HIPS.CommonSchemas.PatientIdentifier;
using System;
using PUMA.PcehrDataStore.Schemas;
#endregion

namespace PUMA.Client.Proxy
{
    /// <summary>
    /// 
    /// </summary>
    public class HIPSProxy : ClientBase<IHIPSService>, IHIPSService
    {
        /// <summary>
        /// Default constructor
        /// </summary>
        /// <param name="endpointName"></param>
        public HIPSProxy(string endpointName)
            : base(endpointName)
        {
        }

        /// <summary>
        /// IHIs the search by number.
        /// </summary>
        /// <param name="patientMaster">the patient master to search for</param>
        /// <param name="hospitalId">The hospital id.</param>
        /// <param name="message">The response if IHI not found</param>
        /// <returns></returns>
        public bool IHISearchByNumber(PUMA.PcehrDataStore.Schemas.PatientMaster patientMaster, int hospitalId, out string message)
        {
            return Channel.IHISearchByNumber(patientMaster, hospitalId, out message);
        }

        /// <summary>
        /// IHIs the search by number and PCEHR check.
        /// </summary>
        /// <param name="patientMaster">The patient master.</param>
        /// <param name="hospitalId">The hospital id.</param>
        /// <param name="message">The response if IHI not found</param>
        /// <returns></returns>
        public bool IHISearchByNumberAndPCEHRCheck(PUMA.PcehrDataStore.Schemas.PatientMaster patientMaster, int hospitalId, out string message)
        {
            return Channel.IHISearchByNumberAndPCEHRCheck(patientMaster, hospitalId, out message);
        }

        /// <summary>
        /// Pcehrs the exists.
        /// </summary>
        /// <param name="ihi">The ihi.</param>
        /// <param name="user">The user.</param>
        /// <returns></returns>
        public DoesPcehrExistResponse PcehrExists(string ihi)
        {
            return Channel.PcehrExists(ihi);
        }

        /// <summary>
        /// PCEHRs the upload.
        /// </summary>
        /// <param name="package">The package.</param>
        /// <param name="ihi">The ihi.</param>
        /// <param name="user">The user.</param>
        /// <param name="parentDocumentId">The parent document id.</param>
        /// <returns></returns>
        public string PCEHRUpload(string package, string ihi, string parentDocumentId)
        {
            return Channel.PCEHRUpload(package, ihi, parentDocumentId);
        }

        /// <summary>
        /// Pcehrs the remove.
        /// </summary>
        /// <param name="patientIdentifier">The patient identifier.</param>
        /// <param name="admissionDate">The admission date.</param>
        /// <param name="documentId">The document id.</param>
        /// <param name="reason">The reason.</param>
        /// <param name="user">The user.</param>
        /// <param name="auditInformation">The audit information.</param>
        /// <returns></returns>
        public HipsResponse PcehrRemove(PatientIdentifierBase patientIdentifier, DateTime admissionDate, string documentId, RemovalReason reason, byte[] auditInformation)
        {
            return Channel.PcehrRemove(patientIdentifier, admissionDate, documentId, reason, auditInformation);
        }

        /// <summary>
        /// Gets the current remove reason.
        /// </summary>
        /// <param name="clinicalDocumentId">The clinical document id.</param>
        /// <returns></returns>
        public string GetCurrentRemoveReason(int clinicalDocumentId)
        {
            return Channel.GetCurrentRemoveReason(clinicalDocumentId);
        }
    }
}
