﻿
#region Using Directives
using System.ServiceModel;
using PUMA.ServiceContracts.ServiceInterface;
using HIPS.PcehrDataStore.Schemas;
using System.Collections.Generic;
using System;
using PUMA.PcehrDataStore.Schemas;
using System.Collections.ObjectModel;
using HIPS.CommonSchemas;
#endregion

namespace PUMA.Client.Proxy
{
    /// <summary>
    /// 
    /// </summary>
    public class HospitalProxy : ClientBase<IHospitalService>, IHospitalService
    {
        /// <summary>
        /// Default constructor
        /// </summary>
        /// <param name="endpointName"></param>
        public HospitalProxy(string endpointName)
            : base(endpointName)
        {
        }

        /// <summary>
        /// Gets a list of active hospitals.
        /// </summary>
        /// <returns>List of Hips Hospital objects</returns>
        public List<Hospital> GetActive()
        {
            return Channel.GetActive();
        }

        public List<Hospital> GetAll()
        {
            return Channel.GetAll();
        }

        public List<Hospital> GetAllByDate(DateTime? lastUpdated)
        {
            return Channel.GetAllByDate(lastUpdated);
        }

        public Hospital Get(int hospitalId)
        {
            return Channel.Get(hospitalId);
        }
        /// <summary>
        /// Gets all.
        /// </summary>
        /// <param name="hospitalId">The hospital id.</param>
        /// <returns></returns>
        public ObservableCollection<HospitalWard> GetAllWards(int? hospitalId)
        {
            return Channel.GetAllWards(hospitalId);
        }
    }
}
